#==============================================================================
#
#  CASECONV Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  convproc.h hhpheap.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = convproc.obj convcvsr.obj convconv.obj hhpheap.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJECTS = convproc.obj convcvsr.obj convconv.obj hhpheap.obj conrcout.obj
!endif
!endif
#===================================================================
#
#   Dependencies
#
#===================================================================


all: convproc.lib convproc.dll

#****************************************************************************
# CONVPROC.DEF
#****************************************************************************

convproc.def:
        @echo $@ > con
        @echo LIBRARY CONVPROC                            >  $@
        @echo DATA SHARED                                 >> $@
        @echo PROTMODE                                    >> $@
        @echo HEAPSIZE 0                                  >> $@
        @echo EXPORTS                                     >> $@
        @echo    CONVProc                        @1       >> $@
        @echo    convhlpGetFormatStringLength    @2       >> $@
        @echo    convhlpGetFormatString          @3       >> $@
        @echo    convhlpGetNLSData               @4       >> $@
        @echo    convhlpToUpper                  @5       >> $@
        @echo    convhlpToLower                  @6       >> $@

!if "$(TARGET_PROC)"=="386"
convproc.res: convproc.rc
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
conrcout.obj: convproc.rc
        $(RC) -As,convproc.rc -- $@
!endif
!endif

convproc.obj: convproc.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

convcvsr.obj: convcvsr.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

convconv.obj: convconv.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

hhpheap.obj: hhpheap.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
convproc.dll: $(OBJECTS) convproc.def convproc.res
    $(LINK) @<<convproc.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x convproc.res convproc.dll
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
convproc.dll : $(OBJECTS) convproc.def
        $(LINK) $(MMFLAGS) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)convproc.def $(OBJECTS)
!endif
!endif

#------------------------------------------------------------------------------
# Now build convproc.lib from the DLL just built
#------------------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
convproc.lib:  convproc.dll convproc.def caseconv.mak
   @echo $@ > con
   implib convproc.lib convproc.def
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
convproc.lib: convproc.dll convproc.def
    mlib -Af,$(@B).def -X ar --$@
!endif
!endif


clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
