#==============================================================================
#
#  CDMCIDRV Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  cdaudibm.h hhpheap.h ibmcdrom.h

!if "$(TARGET_PROC)"=="386"
CFLAGS= /C /Ge- /Gm+ /Gs- /Kb- /Ki- /Ms /Sm /Ss+ /O+ /DINCL_32
!endif
#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
IOBJECTS = ibmcdmsc.obj ibmcdpro.obj ibmcdrom.obj cdmccomn.obj cdmcinit.obj \
           hhpheap.obj
COBJECTS = cdaudio.obj cdaudpro.obj cdaudutl.obj cdmccomn.obj cdmcinit.obj \
           hhpheap.obj
!else
!if "$(TARGET_PROC)"=="PPC"
IOBJECTS = ibmcdmsc.obj ibmcdpro.obj ibmcdrom.obj cdmccomn.obj cdmcinit.obj \
           hhpheap.obj
COBJECTS = cdaudio.obj cdaudpro.obj cdaudutl.obj cdmccomn.obj cdmcinit.obj \
           hhpheap.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: ibmcdrt.dll cdaudiot.dll

ibmcdmsc.obj: ibmcdmsc.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

ibmcdpro.obj: ibmcdpro.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

ibmcdrom.obj: ibmcdrom.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

cdmccomn.obj: cdmccomn.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

cdmcinit.obj: cdmcinit.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

cdaudio.obj:  cdaudio.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

cdaudpro.obj: cdaudpro.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

cdaudutl.obj: cdaudutl.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

hhpheap.obj:  hhpheap.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
ibmcdrt.dll: $(IOBJECTS) ibmcdrom.def
    $(LINK) @<<ibmcdrom.lnk
$(IOBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
ibmcdrom.def
<<keep
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
ibmcdrt.dll : $(IOBJECTS) ibmcdrom.def
        $(LINK) $(NOLIBSFLAG) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)ibmcdrom.def $(STARTUPOBJ) $(IOBJECTS) $(MMFLAGS) $(MTLIB) $(CPPLIB) $(OS2LIB)
!endif
!endif

!if "$(TARGET_PROC)"=="386"
cdaudiot.dll: $(COBJECTS) cdaudio.def
    $(LINK) @<<cdaudio.lnk
$(COBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS)
cdaudio.def
<<keep
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
cdaudiot.dll : $(COBJECTS) cdaudio.def
        $(LINK) $(NOLIBSFLAG) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)cdaudio.def $(STARTUPOBJ) $(COBJECTS) $(MMFLAGS) $(MTLIB) $(CPPLIB) $(OS2LIB)
!endif
!endif

ibmcdrom.def: cdmct.mak
        @echo Creating file <<$(@B).def
LIBRARY IBMCDRT INITINSTANCE TERMINSTANCE
DESCRIPTION 'IBM CD-ROM Toolkit MCI Driver, (c) IBM Corp 1991-1993'
DATA MULTIPLE NONSHARED
HEAPSIZE          44120
STACKSIZE         53000
IMPORTS
  mdm.mdmDriverNotify
EXPORTS
  vsdDriverEntry
<<keep

ibmcdrom.lnk: cdmct.mak
        @echo Creating file <<$(@B).lnk
ibmcdrom ibmcdpro ibmcdmsc cdmccomn cdmcinit hhpheap
ibmcdrt.dll
ibmcdrom.map $(LFLAGS)
$(LIBS)
ibmcdrom.def;
<<keep

cdaudio.def: cdmct.mak
        @echo Creating file <<$(@B).def
LIBRARY CDAUDIOT INITINSTANCE TERMINSTANCE
DESCRIPTION 'CD Audio Toolkit MCI Driver, (c) IBM Corp 1991-1993'
DATA MULTIPLE NONSHARED
HEAPSIZE          44120
STACKSIZE         53000
IMPORTS
  mdm.mdmDriverNotify
  mdm.mciSendCommand
  mdm.mciConnection
  mdm.mciQueryConnections
  mdm.mciQueryDefaultConnections
EXPORTS
   mciDriverEntry
<<keep

cdaudio.lnk: cdmct.mak
        @echo Creating file <<$(@B).lnk
cdaudio cdaudpro cdaudutl cdmccomn cdmcinit hhpheap
cdaudiot.dll
cdaudio.map $(LFLAGS)
$(LIBS)
cdaudio.def;
<<keep

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
