#==============================================================================
#
#  CLOCK Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  clock.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = clock.obj clockdrw.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = clock.obj clockdrw.obj clorcout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = clock.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: clock.exe clock.hlp

!if "$(TARGET_PROC)"=="386"
clock.res: clock.rc clock.dlg clock.h clock.ico
!else
!if "$(TARGET_PROC)"=="PPC"
clorcout.obj : clock.rc clock.dlg clock.h clock.ico
        $(RC) -As,clock.rc -- $@
!endif
!endif

clock.obj: clock.c $(HEADERS)

clockdrw.obj: clockdrw.c $(HEADERS)

clock.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
clock.exe: $(OBJECTS) clock.def clock.res
    $(LINK) @<<clock.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x clock.res clock.exe
!else
!if "$(TARGET_PROC)"=="PPC"
clock.exe : $(OBJECTS) clock.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)clock.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
