#==============================================================================
#
#  CODEC Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  sampdeco.h sampenco.h sampinst.h

!if "$(TARGET_PROC)"=="386"
CFLAGS  = /C+ /Gd- /Ge- /Gm+ /Gs- /Re /J+ /Ki- /Ms /Sm /Sn /Ss+
!endif
#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = sampdeco.obj sampenco.obj sampmain.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = sampdeco.obj sampenco.obj sampmain.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: sampcodc.dll

sampdeco.obj: sampdeco.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

sampenco.obj: sampenco.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

sampmain.obj: sampmain.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
sampcodc.dll: $(OBJECTS) sampcodc.def
    $(LINK) @<<sampcodc.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
!else
!if "$(TARGET_PROC)"=="PPC"
sampcodc.dll : $(OBJECTS) sampcodc.def
        $(LINK) $(NOLIBSFLAG) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)sampcodc.def $(STARTUPOBJ) $(OBJECTS) $(MMFLAGS) $(MTLIB) $(CPPLIB) $(OS2LIB)
!endif
!endif

#------------------------------------------------------------------------
# sampcodc.def file for the DLL
#------------------------------------------------------------------------

sampcodc.def: codec.mak
        @echo Creating file <<$(@B).def
LIBRARY sampcodc INITINSTANCE TERMINSTANCE
SEGMENTS
  PROCESS_SHARED_DATA_SEGMENT CLASS 'DATA' SHARED
DATA MULTIPLE NONSHARED
PROTMODE
HEAPSIZE 0
EXPORTS
  SampleCodecEntry
<<keep

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
