#==============================================================================
#
#  DIVE Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  show.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = show.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = show.obj shorcout.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: show.exe

!if "$(TARGET_PROC)"=="386"
show.res: show.rc showdlg.dlg show.ico prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC"
shorcout.obj : show.rc showdlg.dlg show.ico prodinfo.bmp
        $(RC) -As,show.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp prodinfo.bmp

show.obj: show.c $(HEADERS)

!if "$(TARGET_PROC)"=="386"
show.exe: $(OBJECTS) show.def show.res
    $(LINK) @<<show.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x show.res show.exe
!else
!if "$(TARGET_PROC)"=="PPC"
show.exe : $(OBJECTS) show.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)show.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
