#===================================================================
#
#   DOUBPLAY.MAK - Doubplay Make file
#   Copyright  IBM Corporation 1992
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = doubplay.h
#-------------------------------------------------------------------
#
#   A list of all of the object files
#
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
OBJS = doubplay.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = doubplay.obj dourcout.obj
!endif
!endif

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: doubplay.exe

#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#-------------------------------------------------------------------
#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
doubplay.res: doubplay.rc $(HEADERS) doubplay.ico doubplay.dlg prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
dourcout.obj : doubplay.rc $(HEADERS) doubplay.dlg prodinfo.bmp doubplay.ico
        $(RC) -As,doubplay.rc -- $@
                @del prodinfo.bmp
!endif
!endif

doubplay.obj: doubplay.c $(HEADERS)

prodinfo.bmp :
           copy ..\..\prodinfo.bmp $@

!if "$(TARGET_PROC)"=="386"
doubplay.exe: $(OBJS) doubplay.def doubplay.res
   $(LINK) @<<doubplay.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
   rc -p -x doubplay.res doubplay.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
doubplay.exe : $(OBJS) doubplay.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)doubplay.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
