#==============================================================================
#
#  DUET1 Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  duet1.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = duet1.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = duet1.obj duercout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = duet1.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: duet1.exe duet1.hlp

!if "$(TARGET_PROC)"=="386"
duet1.res: duet1.rc duet1.dlg duet1.h duet1.ico
!else
!if "$(TARGET_PROC)"=="PPC"
duercout.obj : duet1.rc duet1.dlg duet1.h duet1.ico
        $(RC) -As,duet1.rc -- $@
!endif
!endif

duet1.obj: duet1.c $(HEADERS)

duet1.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
duet1.exe: $(OBJECTS) duet1.def duet1.res
    $(LINK) @<<duet1.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x duet1.res duet1.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
duet1.exe : $(OBJECTS) duet1.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)duet1.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
