#==============================================================================
#
#  DUET2 Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  duet2.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = duet2.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = duet2.obj duercout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = duet2.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: duet2.exe duet2.hlp

!if "$(TARGET_PROC)"=="386"
duet2.res: duet2.rc duet2.dlg duet2.h duet2.ico
!else
!if "$(TARGET_PROC)"=="PPC"
duercout.obj : duet2.rc duet2.dlg duet2.h duet2.ico
        $(RC) -As,duet2.rc -- $@
!endif
!endif

duet2.obj: duet2.c $(HEADERS)

duet2.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
duet2.exe: $(OBJECTS) duet2.def duet2.res
    $(LINK) @<<duet2.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x duet2.res duet2.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
duet2.exe : $(OBJECTS) duet2.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)duet2.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
