/****************************************************************************/
/*                                                                          */
/*                    Copyright (c) IBM Corporation 1992, 1993              */
/*                           All Rights Reserved                            */
/*                                                                          */
/* SOURCE FILE NAME: MISHFWD.C                                              */
/*                                                                          */
/* DESCRIPTIVE NAME:  Stream Handler Dll Initialization routine             */
/*                                                                          */
/* FUNCTION: This function is called each time a new process loads this     */
/*           DLL.  If this is the first call, we must register with the     */
/*           SSM as a handler.  For each call, we need to allocate any      */
/*           resources needed on a process basis (GetSeg's, etc), and       */
/*           set up an exit list routine to deallocate these resources.     */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*   _DLL_InitTerm                                                          */
/*   ShExitList                                                             */
/*************************** END OF SPECIFICATIONS **************************/
#define  INCL_NOPMAPI                  /* no PM include files required */
#define  INCL_DOSPROCESS               /* For exit list defines        */
#define  INCL_DOSERRORS
#define  INCL_DOSMISC
#define  INCL_DOSDEVICES
#include <os2.h>

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: ShInit                                                  */
/*                                                                          */
/* DESCRIPTIVE NAME: Stream Handler Initialization routine                  */
/*                                                                          */
/* FUNCTION: DLL initialization routine, to set up control blocks, allocate */
/*           storage etc.                                                   */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT: _DLL_InitTerm                                               */
/*   LINKAGE:   CALL NEAR (0:32)                                            */
/*                                                                          */
/* INPUT:                                                                   */
/*   HMODULE hmod        Module handle                                      */
/*   ULONG   fTerm       DLL termination flag                               */
/*                                                                          */
/* EXIT-NORMAL: NO_ERROR (0)                                                */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*   ERROR_ALLOC_RESOURCES                                                  */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/* INTERNAL REFERENCES:                                                     */
/*        ROUTINES: None                                                    */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*   ROUTINES:                                                              */
/*                                                                          */
/*   DATA STRUCTURES:                                                       */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
#pragma linkage (_DLL_InitTerm, system)

#ifdef MMHACK
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static HFILE   outputFile;
// Vivek's hacks
void myprint(char *s)
{
   ULONG ulBytesWritten;
#ifdef MMDEBUG_PRINT
#if MMDEBUG_LEVEL > 0
   DosWrite(outputFile, s, strlen(s), &ulBytesWritten);
#endif
#endif
}

void myprint1(char *s, long rc)
{
  char msg[256];
#ifdef MMDEBUG
#if MMDEBUG_LEVEL > 0
  sprintf(msg, "%s %d\n", s, rc);
  myprint(msg);
#endif
#endif
}
#endif

ULONG APIENTRY _FSSHInitTerm( HMODULE hmod, ULONG fTerm);

ULONG _DLL_InitTerm( HMODULE hmod, ULONG fTerm)
{
#ifdef MMDEBUG_PRINT
#if MMDEBUG_LEVEL > 0
  ULONG ulAction;
  DosOpen("fsshtest.out", &outputFile, &ulAction, 0, FILE_NORMAL,
           FILE_CREATE | OPEN_ACTION_REPLACE_IF_EXISTS,
           OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYWRITE,
           0L);
#endif
#endif
   return(_FSSHInitTerm(hmod, fTerm));
}

