#==============================================================================
#
#  FSSHT Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS = shifwd.h fssh.h hhpheap.h seekcalc.h shi.h

!if "$(TARGET_PROC)"=="386"
CFLAGS= /C /Ge- /Gm+ /Gs- /Kb- /Ki- /Ms /Sm /Ss+ /O+ /DINCL_32
!else
!if "$(TARGET_PROC)"=="PPC"
OTHER_FLAGS = -DINCL_32 -DSYNCPAUSE -DINCL_NEWSH -DTOOLKIT -DINCL_OS2MM
DLLCFLAGS=$(DLLCFLAGS) $(OTHER_FLAGS)
!endif
!endif
#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJS = fsshread.obj fsshwrit.obj shioutil.obj shmisc.obj shrouter.obj \
       shstart.obj shstop.obj fsshseek.obj seekcalc.obj fsshass.obj \
       fsshcrea.obj shnegot.obj shdestry.obj shgprot.obj sheprot.obj \
       shiprot.obj fsshgdat.obj fsshinit.obj fsshfwd.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJS = fsshread.obj fsshwrit.obj shioutil.obj shmisc.obj shrouter.obj \
       shstart.obj shstop.obj fsshseek.obj seekcalc.obj fsshass.obj \
       fsshcrea.obj shnegot.obj shdestry.obj shgprot.obj sheprot.obj \
       shiprot.obj fsshgdat.obj fsshinit.obj fsshfwd.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: fssht.dll

fsshread.obj:  fsshread.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
fsshwrit.obj:  fsshwrit.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shioutil.obj:  shioutil.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shmisc.obj:    shmisc.c     $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shrouter.obj:  shrouter.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shstart.obj:   shstart.c    $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shstop.obj:    shstop.c     $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
fsshseek.obj:  fsshseek.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
seekcalc.obj:  seekcalc.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
fsshass.obj:   fsshass.c    $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
fsshcrea.obj:  fsshcrea.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shnegot.obj:   shnegot.c    $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shdestry.obj:  shdestry.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shgprot.obj:   shgprot.c    $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
sheprot.obj:   sheprot.c    $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
shiprot.obj:   shiprot.c    $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
fsshgdat.obj:  fsshgdat.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
fsshinit.obj:  fsshinit.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c
fsshfwd.obj:   fsshfwd.c    $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c


!if "$(TARGET_PROC)"=="386"
fssht.dll: $(OBJS) fssht.def
    $(LINK) @<<fssht.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
fssht.def
<<keep
    rc -p -x fssht.res fssht.dll
!else
!if "$(TARGET_PROC)"=="PPC"
fssht.dll : $(OBJS) fssht.def
        $(LINK) $(NOLIBSFLAG) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)fssht.def $(STARTUPOBJ) $(OBJS) $(MMFLAGS) $(MTLIB) $(CPPLIB) $(OS2LIB)
!endif
!endif

fssht.def: fssht.mak
        @echo Creating file @<<$(@B).def
LIBRARY FSSHT INITINSTANCE
DATA MULTIPLE NONSHARED
SEGMENTS
FSSH_SHR       CLASS 'DATA' SHARED

BASE = 0x1B030000
<<keep

fssht.lnk: fssht.mak
        @echo Creating file <<$(@B).lnk
$(OBJS)
fssht.dll
fssht.map $(LFLAGS)
$(LIBS)
fssht.def;
<<keep

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
