
#define INCL_BASE           // include BASE OS/2 defines
#define INCL_NOPMAPI        // leave out the PM stuff

#include<os2.h>
#include<os2medef.h>
#include<seekcalc.h>


#ifndef NEWCALC

ULONG APIENTRY Bytes2Mmtime( ULONG   ulBytesPerUnit,
                             ULONG   lSeekPoint,
                             MMTIME  mmTimePerUnit,
                             PLONG   plByteSeekPoint )
{
  ULONG rc = 0;

  ULONG ulTemp;
  ulTemp = lSeekPoint / ulBytesPerUnit;

  if (lSeekPoint % ulBytesPerUnit)                                   //16998
     ulTemp++;                                                       //16998

  ulTemp *= mmTimePerUnit;
  *plByteSeekPoint = ulTemp;

  return(rc);
}


ULONG APIENTRY Mmtime2Bytes( ULONG   ulBytesPerUnit,
                             ULONG   lSeekPoint,
                             MMTIME  mmTimePerUnit,
                             PLONG   plByteSeekPoint )
{
  ULONG ulTemp;
  ULONG rc = 0;

  ulTemp = lSeekPoint / mmTimePerUnit;

  if (lSeekPoint % mmTimePerUnit)                                    //16998
     ulTemp++;                                                       //16998

  ulTemp *= ulBytesPerUnit;

  // note:  need to handle overflow situations????

  *plByteSeekPoint = ulTemp;

  return(rc);
}


ULONG APIENTRY AddNCheck(ULONG ulAdd, ULONG ulSeekPoint, PLONG plSeekPoint)
{
   ULONG ulTempHigh, ulTempLow, carry=0;

   ulTempHigh = ulAdd & 0xFFFF0000;
   ulTempHigh = ulTempHigh >> 16;

   ulTempLow  = ulAdd & 0x0000FFFF;

   if ( (ulTempLow + (ulSeekPoint & 0x0000FFFF)) & 0xFFFF0000) carry=1;

   if ( (ulTempHigh + ((ulSeekPoint & 0xFFFF0000)>>16) + carry) & 0xFFFF0000) carry=1;
   else carry = 0;

   *plSeekPoint=ulAdd + ulSeekPoint;

   return(carry);
}



#else
ULONG APIENTRY Bytes2Mmtime( ULONG   lByteSeekPoint,
                             ULONG   ulSamplingRate,
                             PMMTIME pmmTime )
{
  float fanswer;

  fanswer = ( (float)( (float) lByteSeekPoint * (float) 3000) ) / ulSamplingRate;
  *pmmTime = (MMTIME) fanswer;
  return ( 0 );


}


ULONG APIENTRY Mmtime2Bytes( ULONG   lMMTimeSeekPoint,
                             ULONG   ulSamplingRate,
                             PMMTIME pmmTime )
{

  double fanswer;

  fanswer = (float)( (float)( lMMTimeSeekPoint) *(float) (ulSamplingRate) )
              / 3000 ;
  *pmmTime = (MMTIME) fanswer;
  return ( 0 );

}


#endif

