#==============================================================================
#
#  MCDTEMP Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  mcdtemp.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = mcdproc.obj mcdopen.obj mcdclose.obj mcddrvsv.obj mcddrvrt.obj \
          mcdstat.obj mcdinfo.obj mcdfuncs.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJECTS = mcdproc.obj mcdopen.obj mcdclose.obj mcddrvsv.obj mcddrvrt.obj \
          mcdstat.obj mcdinfo.obj mcdfuncs.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: mcdtemp.dll

mcdproc.obj: mcdproc.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

mcdopen.obj: mcdopen.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

mcdclose.obj: mcdclose.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

mcddrvsv.obj: mcddrvsv.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

mcddrvrt.obj: mcddrvrt.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

mcdstat.obj: mcdstat.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

mcdinfo.obj: mcdinfo.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

mcdfuncs.obj: mcdfuncs.c $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
mcdtemp.dll: $(OBJECTS) mcdtemp.def
    $(LINK) @<<mcdtemp.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
mcdtemp.dll : $(OBJECTS) mcdtemp.def
        $(LINK) $(DLLFLAGS) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)mcdtemp.def $(OBJECTS)
!endif
!endif

mcdtemp.def:
        @echo Creating file <<$(@B).def
 LIBRARY MCDTEMP INITINSTANCE
 DATA MULTIPLE NONSHARED
 SEGMENTS
   SHR_SEG       CLASS 'FAR_DATA' SHARED
   SHR_SEG_CONST CLASS 'FAR_DATA' SHARED
   SHR_SEG_BSS   CLASS 'FAR_DATA' SHARED

 EXPORTS   mciDriverEntry
<<keep

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
