#==============================================================================
#
#  MMBROWSE Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  mmbrowse.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = mmbrowse.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJECTS = mmbrowse.obj mmrcout.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: mmbrowse.exe

!if "$(TARGET_PROC)"=="386"
mmbrowse.res: mmbrowse.rc mmbrowse.ico mmbrowse.h
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
mmrcout.obj: mmbrowse.rc mmbrowse.ico mmbrowse.h
        $(RC) -As,mmbrowse.rc -- $@
!endif
!endif

mmbrowse.obj: mmbrowse.c $(HEADERS)

!if "$(TARGET_PROC)"=="386"
mmbrowse.exe: $(OBJECTS) mmbrowse.def mmbrowse.res
    $(LINK) @<<mmbrowse.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x mmbrowse.res mmbrowse.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
mmbrowse.exe : $(OBJECTS) mmbrowse.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)mmbrowse.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
