/********************** START OF SPECIFICATIONS *****************************/
/*                                                                          */
/* SOURCE FILE NAME: IOPRNLS.h                                              */
/*                                                                          */
/* DESCRIPTIVE NAME: IOproc National Language string retrieval header       */
/*                                                                          */
/* COPYRIGHT:               IBM Confidential                                */
/*                  Copyright (c) IBM Corporation 1993                      */
/*                         All Rights Reserved                              */
/*                                                                          */
/* STATUS: OS/2 MM Release 1.10                                             */
/*                                                                          */
/* FUNCTION: Provide function declarations for routines in ioprnls.obj      */
/*           Define constants for user module RCDATA declarations.          */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/* DATE      DEVELOPER         CHANGE DESCRIPTION                           */
/* 03-Feb-93 Joe Nord          Creation - feature 6090 common IOproc NLV    */
/* 21-Feb-93 Joe Nord          Changed to _Optlink calling conventions      */
/* 07-Apr-93 Joe Nord          Added ULCO component                         */
/* 09-Sep-93 Steve Hancock     Added MOND component                         */
/* 08-Oct-93 Mark Pietras      Added INDO component                         */
/* 05-Jan-94 Maria Ingold      Added IND3 copmonent   Defect 11804          */
/* 22-Jun-94 Werner Sharp      Added MPGIO/MPGDCH components 12757          */
/* 11-Jan-95 Lauren Post       Added JPEG component Defect XXXXX            */
/************************ END OF SPECIFICATIONS *****************************/


#define IOPRNLS_CODEPAGE           1    /* 1..99 for IOPRNLS component */
#define IOPRNLS_COUNTRYCODE        2

#define IOPRNLS_AVIO_BASE        100    /* 100..199 for AVIO component */
#define IOPRNLS_IAVA_BASE        200
#define IOPRNLS_IAVI_BASE        300
#define IOPRNLS_IB13_BASE        400
#define IOPRNLS_IB20_BASE        500
#define IOPRNLS_IMMO_BASE        600
#define IOPRNLS_IRDI_BASE        700
#define IOPRNLS_IVOC_BASE        800
#define IOPRNLS_IWAV_BASE        900
#define IOPRNLS_MIIO_BASE       1000
#define IOPRNLS_MMIO_BASE       1100
#define IOPRNLS_PCDIO_BASE      1200
#define IOPRNLS_APIO_BASE       1300
#define IOPRNLS_ULDC_BASE       1400
#define IOPRNLS_TGA_BASE        1500
#define IOPRNLS_WI30_BASE       1600
#define IOPRNLS_ULCO_BASE       1700
#define IOPRNLS_MOND_BASE       1800
#define IOPRNLS_INDO_BASE       1900
#define IOPRNLS_IND3_BASE       2000
#define IOPRNLS_MPGIO_BASE      2100
#define IOPRNLS_MPGDCH_BASE     2200
#define IOPRNLS_FLIC_BASE       2300
#define IOPRNLS_FLIO_BASE       2400
#define IOPRNLS_JPEG_BASE       2500
#define IOPRNLS_PCX_BASE        2600
#define IOPRNLS_TIF_BASE        2700
#define IOPRNLS_GIF_BASE        2800


/*
** Function declarations for routines implemented in ioprnls.c
** The object file ioprnls.obj is linked into user modules (IOprocs).
** The routines below (load the resource DLL) and return translated
** strings.  This insulates IOprocs from language dependence.
**
** See implementation (ioprnls.c) for documentation
** on function parameters and behavior.
*/

ULONG _Optlink IOPRNLS_GetNLSData
                  (PULONG pulCodePage,
                   PULONG pulCountryCode);

ULONG _Optlink IOPRNLS_GetFormatString
                  (ULONG ulSearchId,
                   PSZ   pszFormatString,
                   ULONG ulBufSize);
