#==============================================================================
#
#  MMOTTK Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS = mmotproc.h

!if "$(TARGET_PROC)"=="386"
CFLAGS= /C /Ge- /Gm+ /Gs- /Kb- /Ki- /Ms /Sm /Ss+ /O+ /DINCL_32
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OTHER_FLAGS = -DTOOLKIT -DINCL_OS2MM
CFLAGS=$(CFLAGS) $(OTHER_FLAGS)
!endif
!endif
#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJS = mmotproc.obj mmotfunc.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = mmotfunc.obj mmotproc.obj  mmorcout.obj ioprnls.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: mmottk.dll

!if "$(TARGET_PROC)"=="386"
mmotproc.res: mmotproc.rc prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
mmorcout.obj: mmotproc.rc prodinfo.bmp
        $(RC) -As,mmotproc.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp prodinfo.bmp

mmotproc.obj:   mmotproc.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

mmotfunc.obj:   mmotfunc.c  $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

ioprnls.obj:    ioprnls.c   $(HEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
mmottk.dll: $(OBJS) mmotproc.def mmotproc.res
    $(LINK) @<<mmotproc.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
mmotproc.def
<<keep
    rc -p -x mmotproc.res mmottk.dll
!else
!if "$(TARGET_PROC)"=="PPC"
mmottk.dll : $(OBJS) mmotproc.def
        $(LINK) $(NOLIBSFLAG) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)mmotproc.def $(STARTUPOBJ) $(OBJS) $(MTLIB) $(MMFLAGS) $(CPPLIB) $(OS2LIB)
!endif
!endif

mmotproc.def: mmottk.mak
        @echo Creating file @<<$(@B).def
LIBRARY MMOTTK INITINSTANCE TERMINSTANCE
DATA MULTIPLE NONSHARED
SEGMENTS
   shardata         CLASS 'DATA'        SHARED
   .bss             CLASS 'DATA'     NONSHARED
   DDE4_DATA32      CLASS 'DATA'     NONSHARED
HEAPSIZE 0
IMPORTS
    MM_DosLoadModule           = mdm.21
EXPORTS
   IOProc_Entry    @1
<<keep

mmotproc.lnk: mmottk.mak
        @echo Creating file <<$(@B).lnk
$(OBJS)
mmottk.dll
mmottk.map $(LFLAGS)
$(LIBS)
mmotproc.def;
<<keep

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
