#==============================================================================
#
#  SMVSAMP Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  movie.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = movie.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = movie.obj movrcout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = movie.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: movie.exe movie.hlp

!if "$(TARGET_PROC)"=="386"
movie.res: movie.rc movie.dlg movie.h movie.ico
!else
!if "$(TARGET_PROC)"=="PPC"
movrcout.obj: movie.rc movie.dlg movie.h movie.ico
        $(RC) -As,movie.rc -- $@
!endif
!endif

movie.obj: movie.c $(HEADERS)

movie.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
movie.exe: $(OBJECTS) movie.def movie.res
    $(LINK) @<<movie.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x movie.res movie.exe
!else
!if "$(TARGET_PROC)"=="PPC"
movie.exe : $(OBJECTS) movie.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)movie.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
