#==============================================================================
#
#  RECORDER Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  recorder.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = recorder.obj options.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJECTS = recorder.obj options.obj recrcout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = recorder.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: recorder.exe recorder.hlp

!if "$(TARGET_PROC)"=="386"
recorder.res: recorder.rc recorder.dlg recorder.h recorder.ico
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
recrcout.obj: recorder.rc recorder.dlg recorder.h recorder.ico
        $(RC) -As,recorder.rc -- $@
!endif
!endif

recorder.obj: recorder.c $(HEADERS)

options.obj: options.c $(HEADERS)

recorder.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
recorder.exe: $(OBJECTS) recorder.def recorder.res
    $(LINK) @<<recorder.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x recorder.res recorder.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
recorder.exe : $(OBJECTS) recorder.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)recorder.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
