#=============================================================================
#
#  MCISTRNG Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  mcistrng.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = mcistrng.obj
!else
!if "$(TARGET_PROC)"=="PPC"
OBJECTS = mcistrng.obj mcircout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = mcistrng.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: mcistrng.exe mcistrng.hlp

!if "$(TARGET_PROC)"=="386"
mcistrng.res: mcistrng.rc mcistrng.dlg mcistrng.h mcistrng.ico prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC"
mcircout.obj : mcistrng.rc mcistrng.dlg mcistrng.h mcistrng.ico prodinfo.bmp
        $(RC) -As,mcistrng.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp prodinfo.bmp


mcistrng.obj: mcistrng.c $(HEADERS)

mcistrng.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
mcistrng.exe: $(OBJECTS) mcistrng.def mcistrng.res
    $(LINK) @<<mcistrng.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x mcistrng.res mcistrng.exe
!else
!if "$(TARGET_PROC)"=="PPC"
mcistrng.exe : $(OBJECTS) mcistrng.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)mcistrng.def $(OBJECTS)
!endif
!endif

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
