#==============================================================================
#
#  SHRC Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc


!if "$(TARGET_PROC)"=="386"
CFLAGS= /C /Ge- /Gm+ /Gs- /Kb- /Ki- /Ms /Sm /Ss+ /O+ /DINCL_32
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OTHER_FLAGS = -DINCL_32 -DTOOLKIT -DINCL_OS2MM
CFLAGS=$(CFLAGS) $(OTHER_FLAGS)
!endif
!endif
#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJS = rcstub.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = rcstub.obj rcsrcout.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: shrc.dll

!if "$(TARGET_PROC)"=="386"
ssmres.res: ssmres.rc prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
rcsrcout.obj: ssmres.rc prodinfo.bmp
        $(RC) -As,ssmres.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp prodinfo.bmp

rcstub.obj:   rcstub.c
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
shrc.dll: $(OBJS) shrc.def ssmres.res
    $(LINK) @<<shrc.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
shrc.def
<<keep
    rc -p -x ssmres.res shrc.dll
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
shrc.dll : $(OBJS) shrc.def
        $(LINK) $(DLLFLAGS) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)shrc.def $(OBJS)
!endif
!endif

shrc.def: shrc.mak
        @echo Creating file @<<$(@B).def
LIBRARY SHRC
STUB 'OS2STUB.EXE'
DATA NONE
<<keep

shrc.lnk: shrc.mak
        @echo Creating file <<$(@B).lnk
$(OBJS)
shrc.dll
shrc.map $(LFLAGS)
$(LIBS)
shrc.def;
<<keep

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
