#==============================================================================
#
#  ULTIEYES Sample Makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS =  ultieyes.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJECTS = ultieyes.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJECTS = ultieyes.obj ultrcout.obj
!endif
!endif

#===================================================================
#
#   Dependencies
#
#===================================================================

all: ultieyes.exe

!if "$(TARGET_PROC)"=="386"
ultieyes.res: ultieyes.rc
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
ultrcout.obj: ultieyes.rc
        $(RC) -As,ultieyes.rc -- $@
!endif
!endif

ultieyes.obj: ultieyes.c $(HEADERS)

!if "$(TARGET_PROC)"=="386"
ultieyes.exe: $(OBJECTS) ultieyes.def ultieyes.res
    $(LINK) @<<ultieyes.lnk
$(OBJECTS: =+^
)
$@
$(@B).map
$(MTLIBS) + mmpm2
$(@B).def
<<keep
    rc -p -x ultieyes.res ultieyes.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
ultieyes.exe : $(OBJECTS) ultieyes.def
        $(LINK) $(MMFLAGS) $(LFLAGS) $@ $(DEFOPTS)ultieyes.def $(OBJECTS)
!endif
!endif

ultieyes.def:
        @echo Creating file <<$(@B).def
NAME         ULTIEYES  WINDOWAPI
DESCRIPTION  'UltiEyes'
CODE         MOVEABLE
DATA         MOVEABLE MULTIPLE
PROTMODE
STACKSIZE    32000
<<keep

clean :
        if exist *.exe del *.exe
        if exist *.obj del *.obj
        if exist *.dll del *.dll
