/*=========================================================================\
 *                                                                         *
 *       FILE:wmouse.c                                                     *
 *                                                                         *
 *       DESCRIPTION:                                                      *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *      Created 1991  IBM Corp.                                            *
 *      Updated 1994  IBM Corp.                                            *
 *                                                                         *
 *      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is        *
 *      sample code created by IBM Corporation.  This sample code is not   *
 *      part of any standard or IBM product and is provided to you solely  *
 *      for the purpose of assisting you in the development of your        *
 *      applications.  The code is provided "AS IS", without               *
 *      warranty of any kind.  IBM shall not be liable for any damages     *
 *      arising out of your use of the sample code, even if they have been *
 *      advised of the possibility of such damages.                        *
 *                                                                         *
 *-------------------------------------------------------------------------*
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *--------------------------------------------------------------
 *
 *  This source file contains the following functions:
 *
 *  WReadMouse
 *  WmouseFunctions
\*==============================================================*/

/*--------------------------------------------------------------*\
 *  Include files, macros, defined constants, and externs
\*--------------------------------------------------------------*/
#define  INCL_DOS
#define  INCL_VIO
#define  INCL_KBD
#define  INCL_MOU
#define  INCL_DOSPROCESS

#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include "worms.h"
#include "wrmthrd.h"
#include "wrmhelp.h"



/*--------------------------------------------------------------*\
 *  Global variables  and definitions for this file
\*--------------------------------------------------------------*/

/* temporary define for testing mouse calls - Ken checking on this TEMP */
#define MOUSE_BN1_DN_TMP         0x00000004

MOUEVENTINFO mouev;
HMOU hmou;
/*--------------------------------------------------------------*\
 *  Entry point declarations
\*--------------------------------------------------------------*/
VOID WmouseFunctions(LONG lCol);
/****************************************************************\
 *  Routine Name:
 *--------------------------------------------------------------
 *
 *  Name:
 *
 *  Purpose:
 *
 *  Usage:
 *
 *  Method:
 *          -
 *
 *          -
 *          -
 *
 *          -
 *          -
 *
 *  Returns:
 *
 *
\****************************************************************/
VOID WReadMouse( ULONG lpvMessageData )
{
     PVOID pvMessageData;
     ULONG fWait = MOU_WAIT;
     NOPTRRECT mourt = { 0L,0L,24L,79L};
     /*
      * open the handle for the mouse
      */
     pvMessageData = ( PVOID ) lpvMessageData;
     (*(&hmou)=0);
     MouDrawPtr(hmou);

     do
     {
          /*
           * sit and wait on the event queue
           */

           /* TEMP AMC .... AMC */
          memset(&mouev,'\0', sizeof(mouev));

          MouReadEventQue(&mouev,&fWait,hmou);

          if(mouev.time && !bHelpEnabled)
          {
              /* if(mouev.fs & MOUSE_BN1_DOWN )  * TEMP define for test */
               if(mouev.fs & MOUSE_BN1_DN_TMP )
               {
                    MouRemovePtr(&mourt,hmou);
                    /*
                     * if the button is clicked on any of the functions
                     */
                    if(mouev.row == (TOP_ROW + 2))
                    {
                         WmouseFunctions(mouev.col);
                    }

               }
               MouDrawPtr(hmou);
          }

     }while(!fQuit );


     DosExit(EXIT_THREAD, 0L );
}

/****************************************************************\
 *
 *--------------------------------------------------------------
 *
 *  Name:
 *
 *  Purpose:
 *
 *
 *
 *  Usage:
 *
 *  Method:
 *          -
 *
 *          -
 *          -
 *
 *          -
 *          -
 *
 *  Returns:
 *          VOID
 *
\****************************************************************/
VOID WmouseFunctions(LONG lCol)
{

     /*
      * the add selection (columns 5-7)
      */
     if(lCol >= 5L  && lCol <= 7L)
     {
          WormCreate();
     }
     /*
      * the delete selection (columns 22-27)
      */
     else if(lCol >= 22L && lCol  <=  27L)
     {
          WormDelete();
     }
     /*
      * the exit selection (columns 47-50)
      */
     else if(lCol >= 47L && lCol  <=  50L )
     {
         /*
          * display hit any key to exit
          */
         fQuit = TRUE;
         /* AMC ... AMC Message(ENTER_TO_EXIT,FALSE,FALSE,TRUE,TRUE); */
         ErrorMessage(ENTER_TO_EXIT, TRUE);
     }
     /*
      * the help menu selection (columns 62-65)
      */
     else if(lCol >= 62L && lCol  <=  65L )
     {
        if( WormHelp() )
        {
               ErrorMessage(ERROR_DISP_HELP,TRUE);
        }
     }
     /*
      * any other column selections are invalid choices
      */
     else
     {
          DosBeep(600,175);
     }


}
/*--------------------------------------------------------------*\
 *  End of file : wmouse.c
\*--------------------------------------------------------------*/
