#===================================================================
#
#   Copyright 1991 IBM Corporation
#
#===================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

HEADERS = worms.h wrmthrd.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================

OBJS = worms.obj  wrmthrd.obj init.obj disp.obj wrmhelp.obj wmouse.obj

ALL_IPF =
#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: worms.exe

#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#-------------------------------------------------------------------

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================


worms.obj   : worms.c   $(HEADERS)

wrmthrd.obj : wrmthrd.c $(HEADERS)

init.obj    : init.c    $(HEADERS)

disp.obj    : disp.c    $(HEADERS)

wrmhelp.obj : wrmhelp.c $(HEADERS)

wmouse.obj  : wmouse.c  $(HEADERS)

!if "$(TARGET_PROC)"=="PPC"
worms.exe : $(OBJS) worms32.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)worms32.def $(OBJS)
!else
!if "$(TARGET_PROC)"=="386"
!error "There is no 32-bit worms sample for OS/2 on Intel"
#----------------------------------------------------------------------------
# Please uncomment the following comments to build a worms sample
# for Intel, when there is a def file available. The default .DEF file
# is called worms.def. Please change it on the dependency line as well in
# the list of arguments passed to the linker. Also remove the above
# line prefixed with error when removing the comments below.
#-----------UNCOMMENT THE FOLLWING UPTO <<KEEP FOR 32-bit INTEL .exe---------

#worms.exe : $(COBJ) worms.def
#        $(LINK) $(LFLAGS) @<<worms.lnk
#$(COBJ: =+^
#)
#$@
#$(@B).map
#$(MTLIBS)
#$(@B).def
#<<keep

!endif
!endif
clean :
        if exist *.obj del *.obj
        if exist *.dll del *.dll
        if exist *.exe del *.exe

