#===================================================================
#
#   DLLAPI.MAK - DLL Application Make file
#   (C) Copyright IBM Corporation 1992.
#
#===================================================================

#===================================================================
# Include ibmsamp.inc to define macros based on the target specified by
# TARGET_PROC macro.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = dllapi.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJS = dllapi.obj dlapi_in.obj dlapi_hp.obj dlapi_dg.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = dllapi.obj dlapi_in.obj dlapi_hp.obj dlapi_dg.obj dllrcout.obj
!endif
!endif

ALL_IPF = dllapi.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all:  dllapi.exe dllapi.hlp dllib.dll

#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------

#-------------------------------------------------------------------
# make the .res file from the .rc file. Make sure that this target
# pulls in the prodinfo.bmp file (which dllapi.rc includes) into the
# current directory from its actual directory. To do this, execute a
# copy operation.
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
dllapi.res: dllapi.rc $(HEADERS) dllapi.dlg dllapi.ico prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
dllrcout.obj : dllapi.rc $(HEADERS) dllapi.dlg dllapi.ico prodinfo.bmp
        $(RC) -As,dllapi.rc -- $@
        del prodinfo.bmp
!endif
!endif

dllapi.hlp: $(ALL_IPF)

dllapi.obj: dllapi.c     $(HEADERS)

dlapi_dg.obj: dlapi_dg.c $(HEADERS)

dlapi_in.obj: dlapi_in.c $(HEADERS)

dlapi_hp.obj: dlapi_hp.c $(HEADERS)

prodinfo.bmp :
          copy ..\..\prodinfo.bmp $@

!if "$(TARGET_PROC)"=="386"
dllapi.exe: $(OBJS) dllapi.def dllapi.res
    $(LINK) @<<dllapi.lnk
$(OBJS: =+^
)
$@
dllapi.map
$(MTLIBS)
dllapi.def
<<keep
    rc -p -x dllapi.res dllapi.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
dllapi.exe : $(OBJS) dllapi.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)dllapi.def $(OBJS)
!endif
!endif

#===================================================================
#
#   DLLIB.MAK - Dynamic Linking Library Make file
#   (C) Copyright IBM Corporation 1992.
#
#===================================================================
LIBHEADERS  = dllib.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
DLL_OBJS = dllib.obj

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
dllib.obj : dllib.c $(LIBHEADERS)
        icc /c /Ge- /Gd- /Se /Re /ss /Ms /Gm+ /Kb+ /Ti+ /D__MIG_LIB__ -Fodllib.obj dllib.c
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
dllib.obj : dllib.c $(LIBHEADERS)
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $(@B).c
!endif
!endif

!if "$(TARGET_PROC)"=="386"
dllib.dll: $(DLL_OBJS)  dllib.def
    $(LINK) @<<dllib.lnk
$(DLL_OBJS: =+^
)
$@
dlllib.map
$(DLLLIBS)
$(@B).def
<<keep
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
dllib.dll : $(DLL_OBJS) dllib.def
        $(LINK) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)dllib.def $(DLL_OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
