#===================================================================
#
#   EAS.MAK - EAS Application Make file
#   (C) Copyright IBM Corporation 1992.
#
#===================================================================

#===================================================================
# Include ibmsamp.inc to define macros based on the target specified by
# TARGET_PROC macro.
#===================================================================
!include ..\..\ibmsamp.inc

HEADERS = eas.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================

!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = eas.obj easea.obj easfile.obj easinit.obj eashelp.obj easrcout.obj
!else
!if "$(TARGET_PROC)"=="386"
OBJS = eas.obj easea.obj easfile.obj easinit.obj eashelp.obj
!endif
!endif

ALL_IPF = eas.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: eas.exe eas.hlp

#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
eas.res: eas.rc $(HEADERS) eas.ico eas.dlg prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
easrcout.obj : eas.rc $(HEADERS) eas.ico eas.dlg prodinfo.bmp
               $(RC) -As,eas.rc -- $@
               del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\$@ $@

eas.hlp: $(ALL_IPF)

eas.obj: eas.c $(HEADERS)

easea.obj: easea.c $(HEADERS)

easfile.obj: easfile.c $(HEADERS)

easinit.obj: easinit.c $(HEADERS)

eashelp.obj: eashelp.c $(HEADERS)

!if "$(TARGET_PROC)"=="386"
eas.exe: $(OBJS) eas.res eas.def
    $(LINK) @<<eas.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x eas.res eas.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
eas.exe : $(OBJS) eas.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)eas.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
