#===================================================================
#
#   HANOI.MAK - Hanoi Make file
#   Copyright  IBM Corporation 1992
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = hanoi.h
#-------------------------------------------------------------------
#
#   A list of all of the object files
#
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
OBJS = hanoi.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = hanoi.obj hanrcout.obj
!endif
!endif

ALL_IPF = hanoi.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: hanoi.exe hanoi.hlp

#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#-------------------------------------------------------------------
#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
hanoi.res: hanoi.rc $(HEADERS) hanoi.ico hanoi.dlg prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
hanrcout.obj : hanoi.rc $(HEADERS) hanoi.dlg prodinfo.bmp hanoi.ico
                $(RC) -As,hanoi.rc -- $@
                @del prodinfo.bmp
!endif
!endif

hanoi.hlp: $(ALL_IPF)

hanoi.obj: hanoi.c $(HEADERS)

prodinfo.bmp :
           copy ..\..\prodinfo.bmp $@

!if "$(TARGET_PROC)"=="386"
hanoi.exe: $(OBJS) hanoi.def hanoi.res
   $(LINK) @<<hanoi.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
   rc -p -x hanoi.res hanoi.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
hanoi.exe : $(OBJS) hanoi.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)hanoi.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
