#===================================================================
#   Npipe.mak - Make file for named pipe sample
#   Copyright 1992 IBM Corporation
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc


SVR_HEADERS = svrpmain.h svrpxtrn.h svrpglbl.h svrphelp.h namepipe.h
CLI_HEADERS = clnpmain.h clnpxtrn.h clnpglbl.h clnphelp.h namepipe.h
#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
SVR_OBJS = svrpmain.obj svrpthrd.obj svrppnt.obj svrpgame.obj svrphelp.obj
CLI_OBJS = clnpmain.obj clnpthrd.obj clnphelp.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
SVR_OBJS = svrpmain.obj svrpthrd.obj svrppnt.obj svrpgame.obj svrphelp.obj svrrcout.obj
CLI_OBJS = clnpmain.obj clnpthrd.obj clnphelp.obj clircout.obj
!endif
!endif


#-------------------------------------------------------------------
#   A list of all of the Help text files
#-------------------------------------------------------------------

SVR_IPF = svrnpipe.ipf file.ipf svroptn.ipf help.ipf dlg.ipf
CLI_IPF = clinpipe.ipf clifile.ipf clioptn.ipf help.ipf clidlg.ipf
#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------

all: svrnpipe.exe svrnpipe.hlp \
     clinpipe.exe clinpipe.hlp

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

svrpmain.obj: svrpmain.c $(SVR_HEADERS)

svrpthrd.obj: svrpthrd.c $(SVR_HEADERS)

svrpgame.obj: svrpgame.c $(SVR_HEADERS)

svrppnt.obj:  svrppnt.c  $(SVR_HEADERS)

svrphelp.obj: svrphelp.c $(SVR_HEADERS)


clnpmain.obj: clnpmain.c $(CLI_HEADERS)

clnpthrd.obj: clnpthrd.c $(CLI_HEADERS)

clnphelp.obj: clnphelp.c $(CLI_HEADERS)

!if "$(TARGET_PROC)"=="386"
svrnpipe.res : svrnpipe.rc  prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
svrrcout.obj : svrnpipe.rc prodinfo.bmp
               $(RC) -As,svrnpipe.rc -- $@
!endif
!endif

!if "$(TARGET_PROC)"=="386"
clinpipe.res : clinpipe.rc prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
clircout.obj : clinpipe.rc prodinfo.bmp
               $(RC) -As,clinpipe.rc -- $@
               del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
              copy ..\..\prodinfo.bmp $@

#-------------------------------------------------------------------
#   This section creates the help manager file.  The IPF compiler
#   creates a file called main.hlp which is renamed to template.hlp.
#-------------------------------------------------------------------

svrnpipe.hlp: $(SVR_IPF)
clinpipe.hlp: $(CLI_IPF)

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
svrnpipe.exe: $(SVR_OBJS) svrphelp.obj svrnpipe.def svrnpipe.res
    $(LINK) @<<svrnpipe.lnk
$(SVR_OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x svrnpipe.res svrnpipe.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
svrnpipe.exe : $(SVR_OBJS) svrnpipe.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)svrnpipe.def $(SVR_OBJS)
!endif
!endif


!if "$(TARGET_PROC)"=="386"
clinpipe.exe: $(CLI_OBJS) clnphelp.obj clinpipe.def clinpipe.res
    $(LINK) @<<clinpipe.lnk
$(CLI_OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x clinpipe.res clinpipe.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
clinpipe.exe : $(CLI_OBJS) clinpipe.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)clinpipe.def $(CLI_OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
