#===================================================================
#
#   Copyright 1991 IBM Corporation
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc


SVR_HEADERS = svrqmain.h svrqxtrn.h svrqglbl.h svrqhelp.h queue.h
CLI_HEADERS = cliqmain.h cliqxtrn.h cliqglbl.h cliqhelp.h queue.h
#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
SVR_OBJS = svrqmain.obj svrqthrd.obj svrqpnt.obj svrqhelp.obj svrrcout.obj
CLI_OBJS = cliqmain.obj cliqthrd.obj cliqhelp.obj clircout.obj
!else
!if "$(TARGET_PROC)"=="386"
SVR_OBJS = svrqmain.obj svrqthrd.obj svrqpnt.obj svrqhelp.obj
CLI_OBJS = cliqmain.obj cliqthrd.obj cliqhelp.obj
!endif
!endif

#-------------------------------------------------------------------
#   A list of all of the Help text files
#-------------------------------------------------------------------

SVR_IPF = svrqueue.ipf file.ipf svroptn.ipf help.ipf dlg.ipf
CLI_IPF = cliqueue.ipf file.ipf clientry.ipf help.ipf dlg.ipf
#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------

all: svrqueue.exe svrqueue.hlp cliqueue.exe cliqueue.hlp
#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#-------------------------------------------------------------------

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

!if "$(TARGET_PROC)"=="386"
svrqueue.res : svrqueue.rc prodinfo.bmp svrqhelp.rc svrqhelp.h
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
svrrcout.obj : svrqueue.rc prodinfo.bmp svrqhelp.rc svrqhelp.h
               $(RC) -As,svrqueue.rc -- $@
!endif
!endif

svrqmain.obj: svrqmain.c $(SVR_HEADERS)

svrqthrd.obj: svrqthrd.c $(SVR_HEADERS)

svrqpnt.obj:  svrqpnt.c  $(SVR_HEADERS)

svrqhelp.obj: svrqhelp.c $(SVR_HEADERS)

!if "$(TARGET_PROC)"=="386"
cliqueue.res : cliqueue.rc copyprodinfoagain
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
clircout.obj : cliqueue.rc prodinfo.bmp
               $(RC) -As,cliqueue.rc -- $@
               del prodinfo.bmp
!endif
!endif

cliqmain.obj: cliqmain.c $(CLI_HEADERS)

cliqthrd.obj: cliqthrd.c $(CLI_HEADERS)

cliqhelp.obj: cliqhelp.c $(CLI_HEADERS)


prodinfo.bmp :
              copy ..\..\prodinfo.bmp $@

#-------------------------------------------------------------------
#   This section creates the help manager file.  The IPF compiler
#   creates a file called main.hlp which is renamed to template.hlp.
#-------------------------------------------------------------------

svrqueue.hlp: $(SVR_IPF)
cliqueue.hlp: $(CLI_IPF)

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
svrqueue.exe: $(SVR_OBJS)  svrqueue.def svrqueue.res
    $(LINK) @<<svrqueue.lnk
$(SVR_OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x svrqueue.res svrqueue.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
svrqueue.exe : $(SVR_OBJS) svrqueue.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)svrqueue.def $(SVR_OBJS)
!endif
!endif

!if "$(TARGET_PROC)"=="386"
cliqueue.exe: $(CLI_OBJS) cliqueue.def cliqueue.res
    $(LINK) @<<cliqueue.lnk
$(CLI_OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x cliqueue.res cliqueue.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
cliqueue.exe : $(CLI_OBJS) cliqueue.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)cliqueue.def $(CLI_OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
