#===================================================================
#
#   SEMAPH.MAK - Semaph Application Make file
#   (C) Copyright IBM Corporation 1992.
#
#===================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = semaph.h

#===================================================================
#
#   A list of all of the object files
#   The number of object files differ with respect to the environment
#   because in the WPOS/2 environment, there is one more object file that
#   is produced by the MRES tool. in the OS/2 on Intel, the "rc.exe"
#   burns the .rc file into the .exe file and creates a new .exe file.
#
#===================================================================
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = sem_main.obj sem_user.obj sem_init.obj sem_pnt.obj \
       semaph.obj sem_help.obj sem_dlg.obj semrcout.obj
!else
!if "$(TARGET_PROC)"=="386"
OBJS = sem_main.obj sem_user.obj sem_init.obj sem_pnt.obj \
       semaph.obj sem_help.obj sem_dlg.obj
!endif
!endif

ALL_IPF =  semaph.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: semaph.exe semaph.hlp

#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#-------------------------------------------------------------------
#-------------------------------------------------------------------
#
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#
#-------------------------------------------------------------------

#-------------------------------------------------------------------
# for the WPOS/2 case, we produce a .obj file from the .rc file
# by using the resource compiler (called MRES) directly and for the
# OS/2 case, we "burn" the .rc file into the .exe file using the native
# rc. That is the reason we have an if condition here.
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
semrcout.obj: semaph.rc $(HEADERS) semaph.dlg semaph.ico prodinfo.bmp
              $(RC) -As,semaph.rc -- $@
              del prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="386"
semaph.res : semaph.rc $(HEADERS) semaph.dlg semaph.ico prodinfo.bmp
!endif
!endif

semaph.hlp : $(ALL_IPF)

sem_main.obj: sem_main.c $(HEADERS)

sem_edit.obj: sem_edit.c $(HEADERS)

sem_user.obj: sem_user.c $(HEADERS)

semaph.obj: semaph.c $(HEADERS)

sem_help.obj: sem_help.c $(HEADERS)

sem_init.obj: sem_init.c $(HEADERS)

sem_pnt.obj: sem_pnt.c $(HEADERS)

sem_dlg.obj: sem_dlg.c $(HEADERS)

prodinfo.bmp :
        copy ..\..\prodinfo.bmp $@

!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
semaph.exe : $(OBJS) semaph.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)semaph.def $(OBJS)
!else
!if "$(TARGET_PROC)"=="386"
semaph.exe : $(OBJS) semaph.def semaph.res
        $(LINK) @<<semaph.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
        rc -p -x semaph.res semaph.exe
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
