#----------------------------------------------------------------------------
#
# COMPONENT_NAME: tksort
#
# (C) COPYRIGHT International Business Machines Corp. 1994
# All Rights Reserved
# Licensed Materials - Property of IBM
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
#----------------------------------------------------------------------------

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

all:  sort.exe sort.hlp

HEADERS = sort.h

#-------------------------------------------------------------------
#
#   A list of all of the object files
#
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = sort.obj tkrcout.obj
!else
!if "$(TARGET_PROC)"=="386"
OBJS = sort.obj
!endif
!endif

ALL_IPF = sort.ipf

#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
tkrcout.obj: sort.rc $(HEADERS) sort.ico sort.dlg prodinfo.bmp
                $(RC) -As,sort.rc -- $@
                del prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="386"
sort.res : sort.rc $(HEADERS) sort.ico sort.dlg prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\$@ $@

sort.hlp: $(ALL_IPF)

sort.obj: sort.c $(HEADERS)

!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
sort.exe : $(OBJS) sort.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)sort.def $(OBJS)
!else
!if "$(TARGET_PROC)"=="386"
sort.exe : $(OBJS) sort.def sort.res
        $(LINK) @<<$(@B).lnk
$(OBJS: =+^
)
$@
sort.map
$(MTLIBS)
sort.def
<<keep
        rc -p -x sort.res sort.exe
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
