#===================================================================
#
#   Copyright 1990,1992 IBM Corporation
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = clock.h clkdata.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================

!if "$(TARGET_PROC)"=="386"
OBJS = clock.obj dialogs.obj paint.obj wndproc.obj \
       clkdata.obj udtime.obj digital.obj \
       alarmthd.obj  help.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = clock.obj dialogs.obj paint.obj wndproc.obj \
       clkdata.obj udtime.obj digital.obj \
       alarmthd.obj  help.obj clkrcout.obj
!endif
!endif

ALL_IPF = clock.ipf help.ipf dlg.ipf view.ipf settings.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: clock.exe clock.hlp

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

!if "$(TARGET_PROC)"=="386"
clock.res: clock.rc help.rc clock.ico clock.dlg product.dlg prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
clkrcout.obj : clock.rc help.rc clock.ico clock.dlg product.dlg prodinfo.bmp
               $(RC) -As,clock.rc -- $@
               del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\$@ $@

clock.hlp: $(ALL_IPF)

help.obj : help.c

clock.obj: clock.c

dialogs.obj: dialogs.c

!if "$(TARGET_PROC)"=="386"
clock.exe: clock.res $(OBJS) clock.def
    $(LINK) @<<clock.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
clock.def
<<keep
    rc -p -x clock.res clock.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
clock.exe : $(OBJS) clock.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)clock.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
