#===================================================================
#
#   VMM.MAK - VMM Application Makefile
#
#  Copyright (C) 1992, 1994 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.
#
#===================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = vmm.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJS = vmm_main.obj vmm_init.obj vmm_dlg.obj vmm_user.obj vmm_help.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = vmm_main.obj vmm_init.obj vmm_dlg.obj vmm_user.obj vmm_help.obj \
       vmmrcout.obj
!endif
!endif

ALL_IPF = vmm.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: vmm.exe vmm.hlp

#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
vmm.res: vmm.rc $(HEADERS) vmm.dlg vmm.ico prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
vmmrcout.obj : vmm.rc $(HEADERS) vmm.dlg vmm.ico prodinfo.bmp
               $(RC) -As,vmm.rc -- $@
               del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp $@

vmm.hlp: $(ALL_IPF)

vmm_main.obj: vmm_main.c $(HEADERS)

vmm_user.obj: vmm_user.c $(HEADERS)

vmm_init.obj: vmm_init.c $(HEADERS)

vmm_dlg.obj: vmm_dlg.c $(HEADERS)

vmm_help.obj: vmm_help.c $(HEADERS)

!if "$(TARGET_PROC)"=="386"
vmm.exe: $(OBJS) vmm.def vmm.res
    $(LINK) @<<vmm.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x vmm.res vmm.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
vmm.exe : $(OBJS) vmm.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)vmm.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
