#==============================================================================
#
#  Jigsaw Sample Makefile
#
#  Copyright (C) 1992 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#==============================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS =  globals.h jigsaw.h jighelp.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJS = jigsaw.obj jighelp.obj procs.obj misc.obj globals.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = jigsaw.obj jighelp.obj procs.obj misc.obj globals.obj jigrcout.obj
!endif
!endif

#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
IPFS = jigsaw.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: jigsaw.exe jigsaw.hlp

!if "$(TARGET_PROC)"=="386"
jigsaw.res: jigsaw.rc jigsaw.h jigsaw.ico jighelp.rc jigsaw.dlg prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
jigrcout.obj : jigsaw.rc jigsaw.h jigsaw.ico jighelp.rc jigsaw.dlg prodinfo.bmp
               $(RC) -As,jigsaw.rc -- $@
               del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp $@

jigsaw.obj: jigsaw.c $(HEADERS)

jighelp.obj: jighelp.c $(HEADERS)

procs.obj: procs.c $(HEADERS)

misc.obj: misc.c $(HEADERS)

globals.obj: globals.c $(HEADERS)

jigsaw.hlp: $(IPFS)

!if "$(TARGET_PROC)"=="386"
jigsaw.exe: $(OBJS) jigsaw.def jigsaw.res
    $(LINK) @<<jigsaw.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x jigsaw.res jigsaw.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
jigsaw.exe : $(OBJS) jigsaw.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)jigsaw.def $(OBJS)
!endif
!endif

clean :
        @if exist *.exe del *.exe
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
