#===================================================================
#
#   Clipbrd Make file
#   Copyright 1991 IBM Corporation
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = clipbrd.h

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
OBJS = clipbrd.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = clipbrd.obj clprcout.obj
!endif
!endif

all: clipbrd.exe

#----------------------------------------------------------------------
# changes made to the previous makefile as of 06/24/94.
# the lines "copy ..prodinfo.bmp" and "del prodinfo.bmp"
# have been commented
#----------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
clipbrd.res: clipbrd.rc clipbrd.ico clipbrd.h clipbrd.bmp prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
clprcout.obj : clipbrd.rc clipbrd.ico clipbrd.h clipbrd.bmp prodinfo.bmp
        $(RC) -As,clipbrd.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp $@

clipbrd.obj: clipbrd.c $(HEADERS)

!if "$(TARGET_PROC)"=="386"
clipbrd.exe: $(OBJS)  clipbrd.def clipbrd.res
    $(LINK) @<<clipbrd.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x clipbrd.res clipbrd.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
clipbrd.exe : $(OBJS) clipbrd.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)clipbrd.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
