#===================================================================
#
#  Style Sample Makefile
#
#  Copyright (C) 1992 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
OBJS = sty_main.obj sty_user.obj sty_init.obj sty_pnt.obj sty_dlg.obj \
                    sty_file.obj sty_edit.obj sty_help.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = sty_main.obj sty_user.obj sty_init.obj sty_pnt.obj sty_dlg.obj \
                    sty_file.obj sty_edit.obj sty_help.obj styrcout.obj
!endif
!endif

HEADERS  = sty_dlg.h sty_help.h sty_main.h sty_xtrn.h
#===================================================================
#
#   A list of all of the Help files
#
#===================================================================
ALL_IPF = style.ipf sty_file.ipf sty_edit.ipf sty_help.ipf sty_menu.ipf \
          sty_dlg.ipf

#===================================================================
#
#   Dependencies
#
#===================================================================

all: style.exe style.hlp

# Resources
#


!if "$(TARGET_PROC)"=="386"
sty_main.res: sty_main.rc sty_main.h sty_dlg.h sty_main.dlg sty_help.rc \
              sty_help.h prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
styrcout.obj : sty_main.rc sty_main.h sty_dlg.h sty_main.dlg sty_help.rc \
               sty_help.h prodinfo.bmp
               $(RC) -As,sty_main.rc -- $@
               del prodinfo.bmp
!endif
!endif

sty_main.obj: sty_main.c $(HEADERS)

sty_file.obj: sty_file.c $(HEADERS)

sty_edit.obj: sty_edit.c $(HEADERS)

sty_user.obj: sty_user.c $(HEADERS)

sty_init.obj: sty_init.c $(HEADERS)

sty_pnt.obj: sty_pnt.c $(HEADERS)

sty_dlg.obj: sty_dlg.c $(HEADERS)

sty_help.obj: sty_help.c $(HEADERS) sty_help.h

style.hlp: $(ALL_IPF)

prodinfo.bmp :
        copy ..\..\prodinfo.bmp $@

!if "$(TARGET_PROC)"=="386"
style.exe: $(OBJS) style.def sty_main.res
    $(LINK) @<<style.lnk
$(OBJS)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x sty_main.res style.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
style.exe : $(OBJS) style.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)style.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
