#
#  Dialog Sample Makefile
#
#  Copyright (C) 1992 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc


!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = dialog.obj dlgrcout.obj
!else
!if "$(TARGET_PROC)"=="386"
OBJS = dialog.obj
!endif
!endif

all:    dialog.exe

# Resources
#
!if "$(TARGET_PROC)"=="386"
dialog.res: dialog.h dialog.ico dialog.rc prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
dlgrcout.obj : dialog.h dialog.ico dialog.rc prodinfo.bmp
     $(RC) -As,dialog.rc -- dlgrcout.obj
     del prodinfo.bmp
!endif
!endif

dialog.obj: dialog.c dialog.h

prodinfo.bmp :
        copy ..\..\prodinfo.bmp $@

# Main files: DIALOG.EXE
#
!if "$(TARGET_PROC)"=="386"
dialog.exe:  dialog.def $(OBJS) dialog.res
    $(LINK) @<<dialog.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
        rc -p -x dialog.res dialog.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
dialog.exe : dialog.def $(OBJS)
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)dialog.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
