# Makefile for DRAGDROP.EXE
# Copyright 1991 IBM Corporation
#
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc


all:    dragdrop.exe dragdrop.hlp

!if "$(TARGET_PROC)"=="386"
OBJS    =       dragdrop.obj dragdrag.obj dragheap.obj draghelp.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = dragdrop.obj dragdrag.obj dragheap.obj draghelp.obj drgrcout.obj
!endif
!endif

# Resources
#
!if "$(TARGET_PROC)"=="386"
dragdrop.res: dragdrop.rc  dragdrop.ico dragdrop.ptr dragdrop.h \
              dragdrop.dlg draghelp.rc  draghelp.h   prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
drgrcout.obj : dragdrop.rc  dragdrop.ico dragdrop.ptr dragdrop.h \
               dragdrop.dlg draghelp.rc  draghelp.h   prodinfo.bmp
               $(RC) -As,dragdrop.rc -- drgrcout.obj
               del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp $@

# C files
#
dragdrop.obj:      dragdrop.c dragdrop.h

draghelp.obj:      draghelp.c dragdrop.h draghelp.h

dragheap.obj:      dragheap.c dragdrop.h

dragdrag.obj:      dragdrag.c dragdrop.h

# Main files:  dragdrop.exe
#

!if "$(TARGET_PROC)"=="386"
dragdrop.exe: dragdrop.def $(OBJS) dragdrop.res
    $(LINK) @<<dragdrop.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(LIBS)
$(@B).def
<<keep
    rc -p -x dragdrop.res dragdrop.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
dragdrop.exe : $(OBJS) dragdrop.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)dragdrop.def $(OBJS)
!endif
!endif

dragdrop.hlp:   dragdrop.ipf dragfile.ipf draghelp.ipf dragdlg.ipf \
                dragmenu.ipf dragwnd.ipf

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
