#===================================================================
#
#   Graphic Sample Make file
#   Created 1991 IBM Corporation
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = graphic.h

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
OBJS = graphic.obj file.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = graphic.obj file.obj grprcout.obj
CFLAGS=$(CFLAGS) -u__STR__
!endif
!endif

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: graphic.exe graphic.hlp

#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#
#-------------------------------------------------------------------

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#   Since the file graphic.res is dependent on graphic.rc and graphic.rc
#   includes prodinfo.bmp, execute a copy instruction to copy prodinfo.bmp
#   from its root directory (..\..) to the current directory.
#
#===================================================================

!if "$(TARGET_PROC)"=="386"
graphic.res: graphic.rc graphic.ico graphic.h prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
grprcout.obj : graphic.rc graphic.ico graphic.h prodinfo.bmp
        $(RC) -As,graphic.rc -- $@
        del prodinfo.bmp
!endif
!endif

graphic.obj: graphic.c $(HEADERS)

file.obj: file.c $(HEADERS)

prodinfo.bmp :
                copy ..\..\prodinfo.bmp $@


#-------------------------------------------------------------------
#   This section creates the help manager file.
#-------------------------------------------------------------------
graphic.hlp: graphic.ipf

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------
!if  "$(TARGET_PROC)"=="386"
graphic.exe: $(OBJS) graphic.def graphic.res
    $(LINK) @<<graphic.lnk
$(OBJS: =+^
)
$(@B).exe
$(@B).map
$(LIBS)
$(@B).def
<<keep
    rc -p -x graphic.res graphic.exe
!else
!if  "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
graphic.exe : $(OBJS) graphic.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)graphic.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
