#===================================================================
#
# Makefile for IPF Sample
# Created by IBM Corporation 1991
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

!if "$(TARGET_PROC)"=="386"
OBJS = ipf.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = ipf.obj ipfrcout.obj
!endif
!endif

#===================================================================

all: ipf.dll ipf.inf

#
# Create .DLL file
#

!if "$(TARGET_PROC)"=="386"
ipf.dll: ipf.def $(OBJS) ipf.res
         $(LINK) @<<ipf.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(DLLLIBS)
ipf.def
<<keep
         rc -p -x ipf.res ipf.dll
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
ipf.dll : $(OBJS) ipf.def
        $(LINK) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)ipf.def $(OBJS)
!endif
!endif

#
# Create .RES file for only native OS/2 on intel
#

!if "$(TARGET_PROC)"=="386"
ipf.res: ipf.rc ipf.h \
         frame1.bmp frame2.bmp frame3.bmp frame4.bmp frame5.bmp prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
ipfrcout.obj : ipf.rc ipf.h frame1.bmp frame2.bmp \
               frame3.bmp frame4.bmp frame5.bmp prodinfo.bmp
        $(RC) -As,ipf.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp $@

ipf.obj: ipf.c ipf.h
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $(@B).c

ipf.inf: ipf.ipf
        $(IPF) /inf ipf.ipf /W3

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
