#Ŀ
#                                                                          
# PROGRAM NAME: PALETTE                                                    
#  A PM program demonstrating vector fonts, palette manager APIs, and IPF  
#  help.                                                                   
#                                                                          
# COPYRIGHT:                                                               
# ----------                                                               
#  Copyright (C) International Business Machines Corp., 1992               
#                                                                          
# DISCLAIMER OF WARRANTIES:                                                
# -------------------------                                                
#  The following [enclosed] code is sample code created by IBM Corporation.
#  This sample code is not part of any standard IBM product and is provided
#  to you solely for the purpose of assisting you in the development of    
#  your applications.  The code is provided "AS IS", without warranty of   
#  any kind.  IBM shall not be liable for any damages arising out of your  
#  use of the sample code, even if they have been advised of the           
#  possibility of such damages.                                            
#                                                                          
# For details on what this program does etc., please see the PALETTE.C     
# file.                                                                    
#                                                                          
#
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

!if "$(TARGET_PROC)"=="386"
OBJS = palette.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = palette.obj palrcout.obj
!endif
!endif

all : palette.exe palette.hlp

!if "$(TARGET_PROC)"=="386"
palette.res:  palette.rc palette.ico palette.h prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
palrcout.obj : palette.rc palette.ico palette.h prodinfo.bmp
               $(RC) -As,palette.rc -- $@
               del prodinfo.bmp
!endif
!endif

palette.obj : palette.c palette.h

palette.hlp : palette.ipf

!if "$(TARGET_PROC)"=="386"
palette.exe : $(OBJS) palette.def palette.res
                $(LINK) /CO /M /PM:PM @<<$(@B).lnk
$(OBJS: =+^
)
$(@B).exe
$(@B).map
$(LIBS)
$(@B).def
<<keep
                rc -p -x palette.res palette.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
palette.exe : $(OBJS) palette.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)palette.def $(OBJS)
!endif
!endif

prodinfo.bmp :
        copy ..\..\prodinfo.bmp $@

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
