#===================================================================
#
#   Print Sample Make file
#   Created 1991 IBM Corporation
#
#===================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\ibmsamp.inc

!if "$(TARGET_PROC)"=="386"
OBJS = img_data.obj img_dlg.obj img_file.obj img_help.obj img_init.obj \
       img_main.obj img_menu.obj img_pnt.obj  img_size.obj img_util.obj \
       img_view.obj imgrcout.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = img_data.obj img_dlg.obj  img_file.obj img_help.obj img_init.obj \
       img_main.obj img_menu.obj img_pnt.obj  img_size.obj img_util.obj \
       img_view.obj imgrcout.obj
!endif
!endif

CFLAGS=$(CFLAGS) -DLINT_ARGS -DHELP_MANAGER_ENABLED -DPORT_32

HEADERS = img_dlg.h img_help.h img_main.h img_xtrn.h

#-------------------------------------------------------------------
#   This section lists all targets to be built by the make.  The
#   makefile builds the executable as well as its associated help
#   file.
#-------------------------------------------------------------------
all: image32.exe image.hlp

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
image32.res: img_main.rc img_main.h img_dlg.h image.dlg \
             img_help.rc img_help.h prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
imgrcout.obj :  img_main.rc img_main.h img_dlg.h image.dlg \
                img_help.rc img_help.h prodinfo.bmp
        $(RC) -As,img_main.rc -- $@
        del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
        copy ..\..\prodinfo.bmp $@

img_main.obj : img_main.c $(HEADERS)

img_menu.obj: img_menu.c  $(HEADERS)

img_sizw.obj: img_size.c  $(HEADERS)

img_file.obj: img_file.c  $(HEADERS)

img_view.obj: img_view.c  $(HEADERS)

img_data.obj: img_data.c  $(HEADERS)

img_init.obj: img_init.c  $(HEADERS)

img_pnt.obj: img_pnt.c    $(HEADERS)

img_dlg.obj: img_dlg.c    $(HEADERS)

img_help.obj: img_help.c  $(HEADERS)

img_util.obj: img_util.c  $(HEADERS)

#-------------------------------------------------------------------
#   This section creates the help manager file.
#-------------------------------------------------------------------
image.hlp: $(ALL_IPF)
     ipfc img_main.ipf /W3
     if exist image.hlp del image.hlp
     rename img_main.hlp image.hlp

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
image32.exe: $(OBJS) image32.def img_ma32.res
    $(LINK) @<<$(@R).lnk
$(OBJS)
$(@B).exe
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x image32.res image32.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
image32.exe : $(OBJS) image32.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)image32.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
