#===================================================================
#
#   Print Sample Make file
#   Created 1991 IBM Corporation
#
#===================================================================

#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

!if "$(TARGET_PROC)"=="386"
OBJS = prtsamp.obj prtcreat.obj prtmenu.obj prtprint.obj prtobj.obj \
       prtprof.obj prtpage.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = prtsamp.obj prtcreat.obj prtmenu.obj prtprint.obj prtobj.obj \
       prtprof.obj prtpage.obj  prtrcout.obj
!endif
!endif

INCS = pmassert.h prtsamp.h prtsdlg.h

#-------------------------------------------------------------------
#   This section lists all targets to be built by the make.  The
#   makefile builds the executable as well as its associated help
#   file.
#-------------------------------------------------------------------
all: prtsamp.exe prtsamp.hlp

#-------------------------------------------------------------------
#   Definition file
#-------------------------------------------------------------------
prtsamp.def:
        @echo Creating .DEF file -- <<$(@R).def
NAME    prtsamp WINDOWAPI

DESCRIPTION 'PM Print Sample Application'

CODE    MOVEABLE
DATA    MOVEABLE MULTIPLE

HEAPSIZE   18192
STACKSIZE  20384
EXPORTS    WinProc
           ObjectWinProc
<<keep

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================
!if "$(TARGET_PROC)"=="386"
prtsamp.res: prtsamp.rc prtsamp.ico prtsamp.dlg prtsdlg.h prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
prtrcout.obj : prtsamp.rc prtsamp.ico prtsamp.dlg prtsdlg.h prodinfo.bmp
               $(RC) -As,prtsamp.rc -- $@
               del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
        copy ..\..\prodinfo.bmp $@

prtcreat.obj: prtcreat.c $(INCS)

prtmenu.obj: prtmenu.c prtshlp.h $(INCS)

prtobj.obj: prtobj.c $(INCS)

prtpage.obj: prtpage.c $(INCS)

prtprof.obj: prtprof.c $(INCS)

prtprint.obj: prtprint.c $(INCS)

prtsamp.obj: prtsamp.c $(INCS)

#-------------------------------------------------------------------
#   This section creates the help manager file.
#-------------------------------------------------------------------
prtsamp.hlp: prtsamp.ipf

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
prtsamp.exe: $(OBJS) prtsamp.def prtsamp.res
    $(LINK) @<<$(@R).lnk
$(OBJS)
$(@B).exe
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x prtsamp.res prtsamp.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
prtsamp.exe : $(OBJS) prtsamp.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)prtsamp.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
