#===================================================================
#
#   Hello Make file
#   Copyright 1991 IBM Corporation
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = hello.h

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="386"
OBJS = hello.obj
#-------------------------------------------------------------------
# If we use the default value of the CC macro which is
# icc /c /Gd- /Se /Re /ss /Ms /Gm+, then the resultant executable
# causes an exception. So therefore CC is being set to the value
# below, which overrides the value it inherited from ibmsamp.inc
# This is required only for compiling for 386 option.
#-------------------------------------------------------------------
CC = icc /c /Ge /Gd- /Se /Re /ss /Gm+
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = hello.obj helrcout.obj
!endif
!endif

hello: hello.exe

!if "$(TARGET_PROC)"=="386"
hello.res: hello.rc hello.ico hello.h prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
helrcout.obj : hello.rc hello.ico hello.h prodinfo.bmp
        $(RC) -As,hello.rc -- $@
        del prodinfo.bmp
!endif
!endif

hello.obj: hello.c $(HEADERS)

prodinfo.bmp :
                copy ..\..\prodinfo.bmp prodinfo.bmp

!if "$(TARGET_PROC)"=="386"
hello.exe: $(OBJS)  hello.def hello.res
    $(LINK) @<<hello.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(LIBS)
$(@B).def
<<keep
    rc -p -x hello.res hello.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
hello.exe : $(OBJS) hello.def
            $(LINK) $(LFLAGS) $@ $(DEFOPTS)hello.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
