#===================================================================
#
#   Template Make file
#   Copyright 1991 IBM Corporation
#
#===================================================================
#===================================================================
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

!include ..\..\ibmsamp.inc

HEADERS = main.h xtrn.h

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
OBJS = main.obj user.obj init.obj pnt.obj dlg.obj help.obj \
       file.obj edit.obj thrd.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = main.obj user.obj init.obj pnt.obj dlg.obj help.obj \
       file.obj edit.obj thrd.obj tmprcout.obj
!endif
!endif

#-------------------------------------------------------------------
#   A list of all of the Help text files
#-------------------------------------------------------------------
ALL_IPF = template.ipf file.ipf edit.ipf help.ipf dlg.ipf menu.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: template.exe template.hlp

#-------------------------------------------------------------------
#   This section creates the command file used by the linker.  This
#   command file is recreated automatically every time you change
#   the object file list, linker flags, or library list.
#-------------------------------------------------------------------

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

!if "$(TARGET_PROC)"=="386"
main.res: main.rc main.ico main.h dlg.h template.dlg help.rc help.h prodinfo.bmp
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
tmprcout.obj: main.rc main.ico main.h dlg.h template.dlg help.rc help.h prodinfo.bmp
              $(RC) -As,main.rc -- $@
              del prodinfo.bmp
!endif
!endif

prodinfo.bmp :
                copy ..\..\prodinfo.bmp $@

main.obj: main.c $(HEADERS)

file.obj: file.c $(HEADERS)

edit.obj: edit.c $(HEADERS)

user.obj: user.c $(HEADERS)

init.obj: init.c $(HEADERS)

pnt.obj: pnt.c $(HEADERS)

dlg.obj: dlg.c $(HEADERS)

help.obj: help.c $(HEADERS) help.h

thrd.obj: thrd.c $(HEADERS)

#-------------------------------------------------------------------
#   This section creates the help manager file.  The IPF compiler
#   creates a file called main.hlp which is renamed to template.hlp.
#-------------------------------------------------------------------
template.hlp: $(ALL_IPF)

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
template.exe: $(OBJS) template.def main.res
    $(LINK) @<<template.lnk
$(OBJS: =+^
)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    rc -p -x main.res template.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
template.exe : $(OBJS) template.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)template.def $(OBJS)
!endif
!endif

clean :
        @if exist *.obj del *.obj
        @if exist *.dll del *.dll
        @if exist *.exe del *.exe
