#===================================================================
# NMAKE-compatible MAKE file for the REXX sample program PMREXX.
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\..\ibmsamp.inc

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = pmrexx.obj rxhafile.obj pmrcout.obj
DLL_OBJS = pmrexxio.obj pmrxsubs.obj pmircout.obj
!endif
#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: pmrexx.exe pmrexxio.dll pmrexxio.hlp

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

pmrexx.obj: pmrexx.c
rxhafile.obj: rxhafile.c pmrexx.h
pmrexxio.obj: pmrexxio.c pmrexxio.h rhdtatyp.h pmrxiodt.h
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

pmrxsubs.obj: pmrxsubs.c pmrexxio.h pmrxiodt.h
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

#-------------------------------------------------------------------
#   This section creates the help manager file.  The IPF compiler
#   creates a file called pmrexxio.hlp.
#-------------------------------------------------------------------
pmrexxio.hlp: pmrexxio.ipf
         ipfc pmrexxio.ipf

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"

pmrexx.res: pmrexx.rc pmrexx.h rxhdluse.h pmrxhlp.h pmrexx.ico
        copy ..\..\..\prodinfo.bmp
        rc -r pmrexx.rc
        del prodinfo.bmp

pmrexxio.res: pmrexxio.rc rxiohlp.rc pmrexxio.h rxhdluse.h pmrexxio.hlp
        rc -r pmrexxio.rc

pmrexx.exe: rxhafile.obj pmrexx.obj pmrexx.res pmrexx.def
        link386  pmrexx+rxhafile,pmrexx.exe,pmrexx,$(LIBS),pmrexx.def /co /map
        rc pmrexx.res

pmrexxio.dll: pmrexxio.obj pmrxsubs.obj pmrexxio.res pmrexxio.def pmrexxio.hlp
        link386  /De pmrexxio+pmrxsubs,pmrexxio.dll,pmrexxio,$(LIBS),pmrexxio.def /map
        rc pmrexxio.res pmrexxio.dll

!endif

!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"

pmrexx.exe : $(OBJS) pmrexx.def
        $(LINK) $(REXXFLAGS) $(LFLAGS) $@ $(DEFOPTS)pmrexx.def $(OBJS)

pmrexxio.dll:  $(DLL_OBJS) pmrexxio.def
        $(LINK) $(REXXFLAGS) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)pmrexxio.def $(DLL_OBJS)

pmircout.obj: pmrexxio.rc
        $(RC) -As pmrexxio.rc -- $@

pmrcout.obj: pmrexx.rc
        copy ..\..\..\prodinfo.bmp
        $(RC) -As pmrexx.rc -- $@
        del prodinfo.bmp

!endif

pmrexx.c : pmrexxio.h    pmrexx.h
rxhafile.c : rxhdluse.h    pmrexx.h      pmrexxio.h
pmrexxio.c : rhdtatyp.h    pmrxiodt.h    pmrexxio.h
rhdtatyp.h : pmrexxio.h

clean :
        if exist *.obj del *.obj
        if exist *.dll del *.dll
        if exist *.exe del *.exe
        if exist *.res del *.res
