#===================================================================
# NMAKE-compatible MAKE file for the REXX sample program REXXCAL2.
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\..\ibmsamp.inc

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
OBJS = rexxcal2.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = rexxcal2.obj rx2rcout.obj
!endif
!endif

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: rexxcal2.exe

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

rexxcal2.obj: rexxcal2.c

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
rexxcal2.exe: $(OBJS)
    $(LINK) @<<rexxcal2.lnk
$(OBJS: =+
)
$@
$(@B).map
-irexx
$(MTLIBS)
<<keep
    rc -p -x rexxcal2.res rexxcal2.exe
!endif

!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
rexxcal2.exe : $(OBJS) rexxcal2.def
        $(LINK) $(REXXFLAGS) $(LFLAGS) $@ $(DEFOPTS)rexxcal2.def $(OBJS)
!endif

!if "$(TARGET_PROC)"=="386"
rexxcal2.res: rexxcal2.rc
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
rx2rcout.obj: rexxcal2.rc
     $(RC) -As rexxcal2.rc -- $@
!endif
!endif


clean :
        if exist *.obj del *.obj
        if exist *.exe del *.exe
        if exist *.res del *.res
