#===================================================================
# NMAKE-compatible MAKE file for the REXX sample program REXXCALC.
# Include the file ibmsamp.inc which defines the various macros
# depending on the target specified.
#===================================================================

include ..\..\..\ibmsamp.inc

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
OBJS = rexxcalc.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = rexxcalc.obj rxcrcout.obj
!endif
!endif

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: rexxcalc.exe

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

rexxcalc.obj: rexxcalc.c

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------

!if "$(TARGET_PROC)"=="386"
rexxcalc.exe: $(OBJS)
    $(LINK) @<<rexxcalc.lnk
$(OBJS: =+
)
$@
$(@B).map
-irexx
$(MTLIBS)
<<keep
    rc -p -x rexxcalc.res rexxcalc.exe
!endif

!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
rexxcalc.exe : $(OBJS) rexxcalc.def
        $(LINK) $(REXXFLAGS) $(LFLAGS) $@ $(DEFOPTS)rexxcalc.def $(OBJS)
!endif

!if "$(TARGET_PROC)"=="386"
rexxcalc.res: rexxcalc.rc
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
rxcrcout.obj: rexxcalc.rc
     $(RC) -As rexxcalc.rc -- $@
!endif
!endif

clean :
        if exist *.obj del *.obj
        if exist *.exe del *.exe
        if exist *.res del *.res
