#****************************************************************************
#
#  Object Rexx - Animals Sample makefile - SOM 2.0 / IDL version
#
#  Copyright (C) 1993, 1994 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.
#
#      NOTE: you will have to modify the environment variables to suit
#            your environment
#
#****************************************************************************
!include ..\..\..\ibmsamp.inc

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************
.SUFFIXES: .c .obj .dll .idl .h .ih .res .def .rc .ifp .hlp

#****************************************************************************
#  No environment is setup for installation stuff since the
#  the installation program sets up this for us. Therefore we assume
#  all the environment variables have been properly initialized.We set
#  up the env. only for the 386 option.
#****************************************************************************

!if "$(TARGET_PROC)"=="386"
SOMTEMP = .\somtemp

!if [set SMTMP=$(SOMTEMP)] || \
    [set SMEMIT=ih;h;c] || \
    [set SMADDSTAR=1] || \
    [set SMNOTC=1]
!endif

!if [cd $(SOMTEMP)]
!  if [md $(SOMTEMP)]
!    error error creating $(SOMTEMP) directory
!  endif
!else
!  if [cd ..]
!    error - Couldn't cd .. from $(SOMTEMP) directory
!  endif
!endif

!endif



#****************************************************************************
# Compiler/tools Macros
#****************************************************************************


#****************************************************************************
# Set up Macros that will contain all the different dependencies for the
# executables and dlls etc. that are generated.
#****************************************************************************
!if "$(TARGET_PROC)"=="PPC"
OBJS = animal.obj dog.obj bdog.obj ldog.obj sominit.obj
!if "$(CSETPPC)" == "1"
ICCFLAGS       = /Ge- /c /Ss
CC             = icc $(ICCFLAGS) $(DBG_CFLAGS)
.c.obj:
   $(CC) -Fo$*.obj $*.c
!endif
!else
!if "$(TARGET_PROC)"=="386"
CFLAGS = /Ge-
OBJS = animal.obj dog.obj bdog.obj ldog.obj sominit.obj
DLLLIBS = $(DLLLIBS) somtk
LDFLAGS = /noi /map /nol /exepack /packcode /packdata /align:16

.c.obj :
        $(CC) $(CFLAGS) -Fo$*.obj $*.c
!endif
!endif


#****************************************************************************
#   Setup the inference rules for compiling source code to
#   object code.
#
#   The inference rule to convert from .idl to .ih and from .idl to .c
#   have been picked up from the corresponding makefiles for the build
#   environment (where they have been successfully built on the writer's
#   desktop) using the SOM2.0 tools. The difference between the build
#   and these inference rules are the -I directives. they are missing in
#   the installation environment because they are set up by the installation
#   program and the tools automatically use them.
#****************************************************************************
.idl.h:
        sc -p -mppc -mnotc -mnothunks -maddstar -mnoint -S128000 -C128000 -s"h"  -E SOMIR=ORXSMP.IR $*.idl

.idl.ih:
        sc -p -mppc -mnotc -mnothunks -maddstar -mnoint -S128000 -C128000 -s"ih" -E SOMIR=ORXSMP.IR $*.idl

.idl.c:
        sc -p -mppc -mnotc -mnothunks -maddstar -mnoint -S128000 -C128000 -s"c"  -E SOMIR=ORXSMP.IR $*.idl

all:    clean animals.dll

clean:
        @if exist animal.h  del animal.h
        @if exist animal.ih del animal.ih
        @if exist dog.h     del dog.h
        @if exist dog.ih    del dog.ih
        @if exist bdog.h    del bdog.h
        @if exist bdog.ih   del bdog.ih
        @if exist ldog.h    del ldog.h
        @if exist ldog.ih   del ldog.ih

animal.obj:    $$(@B).c    $$(@B).ih  $$(@B).h $$(@B).idl
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

dog.obj:       $$(@B).c    $$(@B).ih  $$(@B).h $$(@B).idl animal.ih animal.idl
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

bdog.obj:      $$(@B).c    $$(@B).ih  $$(@B).h $$(@B).idl dog.ih    dog.idl
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

ldog.obj:      $$(@B).c    $$(@B).ih  $$(@B).h $$(@B).idl dog.ih    dog.idl
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

sominit.obj:   $$(@B).c    animal.ih  dog.ih   bdog.ih    ldog.ih
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
animals.dll:  $$(@B).def $(OBJS)
        $(LINK) $(LDLFAGS) $(OBJS),$@,,$(DLLLIBS),$*;
!else
!if "$(TARGET_PROC)"=="PPC"
animals.dll : $(OBJS) animals.def
        $(LINK) $(DLLFLAGS) $(SOMFLAGS) $(LFLAGS) $@ $(DEFOPTS)animals.def $(OBJS)
!endif
!endif
