#pragma	title("Simple Example  --  Version 1.0  --  (ExampWnd.C)")
#pragma	subtitle("   Exmaple Window - Interface Definitions")

#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/

#if defined(__IBMC__)

#pragma	info(noext)

#endif

#include <os2.h>

#include "appdefs.h"
#include "example.h"

/* This	module contains	routine	used to	handle the main	window.		*/

/* Filename:   ExampWnd.C						*/

/*  Version:   1.0							*/
/*  Created:   1994-08-22						*/
/*  Revised:   1994-08-22						*/

/* Routines:   MRESULT EXPENTRY	ExampleWndProc(HWND hWnd, ULONG	msg,	*/
/*					       MPARAM mp1, MPARAM mp2);	*/


/* Copyright  1994  Prominare Inc.  All Rights	Reserved.		*/

/* --------------------------------------------------------------------	*/

#pragma	subtitle("   Client Window - Client Window Procedure")
#pragma	page( )

/* --- ExampleWndProc -------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages sent to the	*/
/*     applications client window.					*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Window Handle					*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     ExampleWndProc =	Message	Handling Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY ExampleWndProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
RECTL rcl;			    /* Window Rectangle			*/
HPS   hPS;			    /* Presentation Space Handle	*/


switch ( msg )
   {
			/* Window being	created, perform window		*/
			/* initialization				*/
   case	WM_CREATE :
			/************************************************/
			/* UreGetTemplate is used to allow controls in	*/
			/* windows.  Do	not remove this	function if you	*/
			/* intend to include controls within the window.*/
			/************************************************/

	UreGetTemplate(hWnd, ID_WINDOW);
	break;
			/* Perform menu	initialization			*/
   case	WM_INITMENU :
	switch ( SHORT1FROMMP(mp1) )
	    {
	   case	IDM_FILE :
		break;

	    }
	break;
			/* Process menu	and button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case IDM_EXAMPLE :
		WinDlgBox(HWND_DESKTOP,	hwndExampleFrame, (PFNWP)ExampleDlgProc,
			  (HMODULE)NULL, DLG_EXAMPLE, NULL);
		break;
	    }
	break;
			/* Erase window	background			*/

   case	WM_ERASEBACKGROUND :
	WinQueryWindowRect(hWnd, &rcl);
	WinFillRect((HPS)LONGFROMMP(mp1), &rcl,	SYSCLR_WINDOW);
	break;
			/* Paint client	window				*/
   case	WM_PAINT :
	hPS = WinBeginPaint(hWnd, (HPS)NULL, &rcl);
	WinFillRect(hPS, &rcl, SYSCLR_WINDOW);
	WinEndPaint(hPS);
	break;
			/* Close the application			*/
   case	WM_CLOSE :
	WinPostMsg(hWnd, WM_QUIT, 0L, 0L);
	break;
			/* Window being	destroyed, perform clean-up	*/
			/* operations					*/
   case	WM_DESTROY :
	break;

			/* Default message processing			*/
   default :
       return(WinDefWindowProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
