#pragma	title("Multi Window Example  --  Version 1.0  --  (MultiWnd.C)")
#pragma	subtitle("   Main Window - Interface Definitions")

#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/

#if defined(__IBMC__)

#pragma	info(noext)

#endif

#include <os2.h>

#include "appdefs.h"
#include "multiwin.h"

/* This	module contains	the main window	routine.			*/

/* Filename:   MultiWnd.C						*/

/*  Version:   1.0							*/
/*  Created:   1994-08-18						*/
/*  Revised:   1994-08-18						*/

/* Routines:   MRESULT EXPENTRY	MultiWndProc(HWND hWnd,	ULONG msg,	*/
/*					     MPARAM mp1, MPARAM	mp2);	*/


/* Copyright  1994  Prominare Inc.  All Rights	Reserved.		*/

/* --------------------------------------------------------------------	*/

#pragma	subtitle("   Main Window - Client Window Procedure")
#pragma	page( )

/* --- MultiWndProc ---------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages sent to the	*/
/*     applications client window.					*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Window Handle					*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     MultiWndProc = Message Handling Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY MultiWndProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
RECTL rcl;			    /* Window Rectangle			*/
HPS   hPS;			    /* Presentation Space Handle	*/


switch ( msg )
   {
			/* Window being	created, perform window		*/
			/* initialization				*/
   case	WM_CREATE :
			/************************************************/
			/* UreGetTemplate is used to allow controls in	*/
			/* windows.  Do	not remove this	function if you	*/
			/* intend to include controls within the window.*/
			/************************************************/

	UreGetTemplate(hWnd, ID_WINDOW);
	break;
			/* Perform menu	initialization			*/
   case	WM_INITMENU :
	switch ( SHORT1FROMMP(mp1) )
	    {
	   case	IDM_FILE :
		break;

	   case	IDM_HELP :
		break;

	    }
	break;
			/* Process menu	and button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case IDM_EXAMPLE :
		WinDlgBox(HWND_DESKTOP,	hwndMultiWndFrame, (PFNWP)ExampleDlgProc,
			  (HMODULE)NULL, DLG_EXAMPLE, NULL);
		break;
	    case IDM_EXIT :
		break;
	    case IDM_HELPFORHELP :
		break;
	    case IDM_EXTENDEDHELP :
		break;
	    case IDM_KEYSHELP :
		break;
	    case IDM_HELPINDEX :
		break;
	    case IDM_ABOUT :
		WinDlgBox(HWND_DESKTOP,	hwndMultiWndFrame, (PFNWP)AboutDlgProc,
			  (HMODULE)NULL, DLG_ABOUT, NULL);
		break;
	    }
	break;
			/* Erase window	background			*/

   case	WM_ERASEBACKGROUND :
	WinQueryWindowRect(hWnd, &rcl);
	WinFillRect((HPS)LONGFROMMP(mp1), &rcl,	SYSCLR_WINDOW);
	break;
			/* Paint client	window				*/
   case	WM_PAINT :
	WinFillRect(hPS	= WinBeginPaint(hWnd, (HPS)NULL, &rcl),	&rcl, SYSCLR_WINDOW);
	WinEndPaint(hPS);
	break;
			/* Close the application			*/
   case	WM_CLOSE :
	WinPostMsg(hWnd, WM_QUIT, 0L, 0L);
	break;
			/* Window being	destroyed, perform clean-up	*/
			/* operations					*/
   case	WM_DESTROY :
	break;
			/* Default message processing			*/
   default :
       return(WinDefWindowProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
