#pragma	title("Test Bed Application  --  Version 1.1  --  (TestWnd.C)")
#pragma	subtitle("   Client Window - Interface Definitions")

#if defined(__IBMC__)

#pragma	info(noext, nopar)

#endif

#define	INCL_DOS		   /* Include OS/2 DOS Kernal		*/
#define	INCL_DOSERRORS		   /* Include OS/2 DOS Kernal Errors	*/
#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/

static char *MODID = "@(#)testwnd.c:1.01";

#include <os2.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <stdio.h>

#include <pmcx.h>

#include "appdefs.h"
#include "testbed.h"

/* This	module contains	routine	used to	process	the messages for the	*/
/* applications	client window.						*/

/* Filename:   TestWnd.C						*/

/*  Version:   1.1							*/
/*  Created:   1993-12-21						*/
/*  Revised:   1995-11-04						*/

/* Routines:   MRESULT EXPENTRY	TestWndProc(HWND hWnd, ULONG msg,	*/
/*					    MPARAM mp1,	MPARAM mp2);	*/


/* Copyright  1989-1995  Prominare Inc.  All Rights Reserved.		*/

/* --------------------------------------------------------------------	*/

PSZ pszAppName = "PMCX Test Facility";

/* --- ID Box Messages ------------------------------------------------	*/

#define	IDBM_SETIDSYMBOLVALUE	    0x019bUL
#define	IDBM_QUERYVALUELEN	    0x01a0UL
#define	IDBM_QUERYIDSYMBOLVALUE	    0x019cUL

/* --- Module Prototypes ----------------------------------------------	*/

VOID EXPENTRY SetSymbol(HWND hWnd, ULONG id, PUSERSTYLE	pust);
BOOL EXPENTRY GetSymbol(HWND hWnd, ULONG id, PUSERSTYLE	pust);
VOID EXPENTRY GetPresParams(HWND hWnd);
BOOL EXPENTRY CUACheck(HWND hWnd, ULONG	idEntryField, LONG iCUACompliance);
VOID	      TestDynamicLoad(HWND hWnd, PSZ pszName);

/* --- PMCX DLL	Prototypes --------------------------------------------	*/

#define	ORD_XXXXREGISTER   1
#define	ORD_XXXXQUERY	   2
#define	ORD_XXXXSTYLES	   3

BOOL   (* EXPENTRY pfnXxxxRegister)(HAB	hab);
BOOL   (* EXPENTRY pfnXxxxQuery)(PUSERINFO  pui);
BOOL   (* EXPENTRY pfnXxxxStyles)(HWND hWnd, ULONG msg,	MPARAM mp1, MPARAM mp2);

/* --- Custom Control Prototypes --------------------------------------	*/

BOOL	EXPENTRY PatternQuery(PUSERINFO	pUserInfo);
MRESULT	EXPENTRY PatternStyles(HWND hWnd, ULONG	msg, MPARAM mp1, MPARAM	mp2);

#pragma	subtitle("   Client Window - Symbol Set Procedure")
#pragma	page( )

/* --- SetSymbol ------------------------------------------------------	*/
/*									*/
/*     This function is	used to	test the symbol	set function		*/
/*     from the	custom control.						*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND	  hWnd;	= Dialogue Window Handle			*/
/*     ULONG	  id;	= Symbol Entry Field ID				*/
/*     PUSERSTYLE pust;	= User Style Pointer				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     Nothing								*/
/*									*/
/* --------------------------------------------------------------------	*/

VOID EXPENTRY SetSymbol(HWND hWnd, ULONG id, PUSERSTYLE	pust)

{

WinSendDlgItemMsg(hWnd,	id, IDBM_SETIDSYMBOLVALUE, MPFROMLONG(pust->id), MPFROMP(pust->szid));

}
#pragma	subtitle("   Client Window - Validate Symbol Procedure")
#pragma	page( )

/* --- GetSymbol ------------------------------------------------------	*/
/*									*/
/*     This function is	used to	test the Symbol	validation call	back	*/
/*     from the	custom control.						*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND	  hWnd;	= Dialogue Window Handle			*/
/*     ULONG	  id;	= Symbol Entry Field ID				*/
/*     PUSERSTYLE pust;	= User Style Pointer				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     GetSymbolID =  TRUE : Symbol and	ID Validated			*/
/*		   = FALSE : Symbol and	ID Invalid			*/
/*									*/
/* --------------------------------------------------------------------	*/

BOOL EXPENTRY GetSymbol(HWND hWnd, ULONG id, PUSERSTYLE	pust)

{

if ( WinSendDlgItemMsg(hWnd, id, IDBM_QUERYVALUELEN, 0L, 0L) ==	0 )
   {
   WinMessageBox(HWND_DESKTOP, hWnd, "ID missing.", pszAppName,	0UL, MB_OK | MB_ICONQUESTION | MB_MOVEABLE);
   return(FALSE);
   }
else
   {
   WinSendDlgItemMsg(hWnd, id, IDBM_QUERYIDSYMBOLVALUE,	MPFROMP(&pust->id), MPFROMP(pust->szid));

   if (	pust->id == 0xffffffffUL )
       pust->szid[0] = (CHAR)0;
   return(TRUE);
   }
}
#pragma	subtitle("   Client Window - Client Window Procedure")
#pragma	page( )

/* --- GetPresParams --------------------------------------------------	*/
/*									*/
/*     This function is	used to	test the Presentation Parameters	*/
/*     call back from the custom control.				*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND hWnd; = Dialogue Window Handle				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     Nothing								*/
/*									*/
/* --------------------------------------------------------------------	*/

VOID EXPENTRY GetPresParams(HWND hWnd)

{

WinMessageBox(HWND_DESKTOP, hWnd, "Font & Colors Callback Test", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);

}
#pragma	subtitle("   Client Window - CUA Check Procedure")
#pragma	page( )

/* --- CUACheck	-------------------------------------------------------	*/
/*									*/
/*     This function is	used to	test the CUA Compliance	call back	*/
/*     from the	custom control.						*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd;	     = Dialogue	Window Handle			*/
/*     ULONG idEntryField;   = PM Message				*/
/*     INT   iCUACompliance; = Message Parameter 1			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     CUACheck	=  TRUE	: CUA Compliant					*/
/*		= FALSE	: CUA Non-Compliant				*/
/*									*/
/* --------------------------------------------------------------------	*/

BOOL EXPENTRY CUACheck(HWND hWnd, ULONG	idEntryField, LONG iCUACompliance)

{
CHAR *pszMsg;			   /* Message String Pointer		*/

switch ( iCUACompliance	)
   {
   case	CUACHK_MNEMONIC	:
       pszMsg =	"CUA mnemonic check.  Press Yes for CUA compliance or no for non-compliance";
       break;

   case	CUACHK_CAPS :
       pszMsg =	"CUA capitalization check.  Press Yes for CUA compliance or no for non-compliance";
       break;

   case	CUACHK_ELLIPSIS	:
       pszMsg =	"CUA ellipsis check.  Press Yes for CUA compliance or no for non-compliance";
       break;
   }

if ( WinMessageBox(HWND_DESKTOP, hWnd, pszMsg, pszAppName, 0UL,	MB_ICONASTERISK	| MB_YESNO | MB_MOVEABLE) == MBID_YES )
   return(TRUE);
else
   return(FALSE);
}
#pragma	subtitle("   Client Window - Style Dialogue Test Procedure")
#pragma	page( )

/* --- TestDynamicLoad ------------------------------------------------	*/
/*									*/
/*     This function is	used to	test dynamic loading of	a PMCX control	*/
/*     and the styles dialogue if requested.				*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND hWnd;	 = Window Handle				*/
/*     PSZ  pszName;	 = DLL Name					*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     Nothing								*/
/*									*/
/* --------------------------------------------------------------------	*/

VOID TestDynamicLoad(HWND hWnd,	PSZ pszName)

{
CHAR	   szFailName[CCHMAXPATH]; /* DLL Load Fail Name Holder		*/
CHAR	   szMessage[512];	   /* Message Buffer			*/
HMODULE	   hmod;		   /* DLL Module Handle			*/
PCHAR	   pch;			   /* String Character Pointer		*/
PUSERINFO  pui;			   /* User Information			*/
PUSERSTYLE pust;		   /* User Style Pointer		*/
ULONG	   ulDosError;		   /* OS/2 Error			*/

if ( (pch = strrchr(pszName, '.')) != NULL )
   if (	!memicmp(pch, ".dll", 5) )
       *pch = (CHAR)NULL;

if ( (ulDosError = DosLoadModule(szFailName, CCHMAXPATH, pszName, &hmod)) != NO_ERROR )
   switch ( ulDosError )
       {
       case ERROR_INIT_ROUTINE_FAILED :
	   if (	WinMessageBox(HWND_DESKTOP, hWnd, "DLL Initialization routine failed.\n\nContinue?", pszAppName, 0UL,
			      MB_ICONASTERISK |	MB_YESNO | MB_MOVEABLE)	== MBID_NO )
	       return;
	   else
	       break;

       case ERROR_FILE_NOT_FOUND :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports DLL not found", pszAppName,	0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_PATH_NOT_FOUND :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Path not found", pszAppName, 0UL, MB_ICONASTERISK |	MB_OK |	MB_MOVEABLE);
	   return;

       case ERROR_TOO_MANY_OPEN_FILES:
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Too many open files", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_ACCESS_DENIED	:
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Access to DLL denied", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_NOT_ENOUGH_MEMORY :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Not enough memory",	pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_BAD_FORMAT :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Bad DLL format", pszAppName, 0UL, MB_ICONASTERISK |	MB_OK |	MB_MOVEABLE);
	   return;

       case ERROR_NOT_DOS_DISK :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Not a DOS disk", pszAppName, 0UL, MB_ICONASTERISK |	MB_OK |	MB_MOVEABLE);
	   return;

       case ERROR_SHARING_VIOLATION :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Sharing violation",	pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_LOCK_VIOLATION :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Lock violation", pszAppName, 0UL, MB_ICONASTERISK |	MB_OK |	MB_MOVEABLE);
	   return;

       case ERROR_SHARING_BUFFER_EXCEEDED :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Sharing buffer exceeded", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_INTERRUPT :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Interrupt",	pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_DRIVE_LOCKED :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Drive locked", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_INVALID_NAME :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Invalid name", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_PROC_NOT_FOUND :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Procedure not found", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_INVALID_SEGMENT_NUMBER :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Invalid segment number", pszAppName, 0UL, MB_ICONASTERISK |	MB_OK |	MB_MOVEABLE);
	   return;

       case ERROR_INVALID_ORDINAL :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Invalid ordinal", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_INVALID_MODULETYPE :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Invalid Module type", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_INVALID_EXE_SIGNATURE	:
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Invalid EXE signature", pszAppName,	0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_EXE_MARKED_INVALID :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports DLL marked invalid", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_INVALID_MINALLOCSIZE :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports MINALLOCSIZE", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_DYNLINK_FROM_INVALID_RING :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Dynamic link from invalid Ring", pszAppName, 0UL, MB_ICONASTERISK |	MB_OK |	MB_MOVEABLE);
	   return;

       case ERROR_INVALID_SEGDPL :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Invalid Segment DPL", pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;

       case ERROR_FILENAME_EXCED_RANGE :
	   WinMessageBox(HWND_DESKTOP, hWnd, "DosLoadModule reports Filename too long",	pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   return;
       }
		       /* Since	there are two different	levels of the	*/
		       /* PMCX,	need to	determine which	level the DLL	*/
		       /* is by	checking for the different function	*/
		       /* names.  First	check for the 32-bit version	*/
		       /* and if the function is not found, then check	*/
		       /* for the 16-bit version.			*/

if ( !DosQueryProcAddr(hmod, ORD_XXXXREGISTER, NULL, (PFN *)(PVOID)&pfnXxxxRegister) )
    {
	    /* Function	found within DLL, therefore assuming */
	    /* that the	DLL is the 32-bit type		     */

    if ( pfnXxxxRegister(hAB) )
       {
       if ( !DosQueryProcAddr(hmod, ORD_XXXXQUERY, NULL, (PFN *)(PVOID)&pfnXxxxQuery) )
	   if (	!DosQueryProcAddr(hmod,	ORD_XXXXSTYLES,	NULL, (PFN *)(PVOID)&pfnXxxxStyles) )
	       {
	       if ( pfnXxxxQuery(pui = (PUSERINFO)malloc(sizeof(USERINFO))) )
		   {
		   pust	= (PUSERSTYLE)malloc(sizeof(USERSTYLE) + pui->utDefined[0].cCtlData);
		   memset(pust,	0, sizeof(USERSTYLE) + pui->utDefined[0].cCtlData);

		       /* Copy control data information	to array	*/
		       /* allocated for	the control data in this	*/
		       /* location					*/

		   if (	pui->utDefined[0].cMaxText )
		       {
		       if ( pui->utDefined[0].cMaxText < 5 )
			   {
			   memcpy(pust->pszText	= (PSZ)malloc(pui->utDefined[0].cMaxText), "Text", pui->utDefined[0].cMaxText -	1);
			   pust->pszText[pui->utDefined[0].cMaxText - 1] = (CHAR)0;
			   }
		       else
			   memcpy(pust->pszText	= (PSZ)malloc(pui->utDefined[0].cMaxText), "Text", pust->cText = 5);
		       }
		   else
		       pust->pszText = NULL;

		   pust->pfnSetSymbolID	   = (PFN)(PVOID)&SetSymbol;
		   pust->pfnGetSymbolID	   = (PFN)(PVOID)&GetSymbol;
		   pust->pfnGetFontClr	   = (PFN)(PVOID)&GetPresParams;
		   pust->pfnCUACheck	   = (PFN)(PVOID)&CUACheck;

		   memcpy(pust->szid, "ID_TESTING", 11);
		   pust->id = 512;

		   if (	WinDlgBox(HWND_DESKTOP,	hwndTestBedFrame, (PFNWP)pfnXxxxStyles,	hmod, pui->utDefined[0].idDlg, (PVOID)pust) == DID_ERROR )
		       {
		       sprintf(szMessage, "XxxxStyles returned DID_ERROR for '%s'", pszName);
		       WinMessageBox(HWND_DESKTOP, hWnd, szMessage, pszAppName,	0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
		       }
		   else
		       {
		       sprintf(szMessage, "Successfully loaded and tested '%s'", pszName);
		       WinMessageBox(HWND_DESKTOP, hWnd, szMessage, pszAppName,	0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
		       }

		   free(pust->pszText);
		   free(pust);
		   free(pui);
		   }
	       else
		   {
		   sprintf(szMessage, "Query failed function for '%s'",	pszName);
		   WinMessageBox(HWND_DESKTOP, hWnd, szMessage,	pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
		   }
	       }
	   else
	       {
	       sprintf(szMessage, "Could not retrieve XxxxStyles function for '%s'", pszName);
	       WinMessageBox(HWND_DESKTOP, hWnd, szMessage, pszAppName,	0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	       }
       else
	   {
	   sprintf(szMessage, "Could not retrieve XxxxQuery function for '%s'",	pszName);
	   WinMessageBox(HWND_DESKTOP, hWnd, szMessage,	pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
	   }
       }
   else
       {
       sprintf(szMessage, "Register failed for '%s'", pszName);
       WinMessageBox(HWND_DESKTOP, hWnd, szMessage, pszAppName,	0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
       }
   }
else
   {
   sprintf(szMessage, "Could not retrieve XxxxRegister function for '%s'", pszName);
   WinMessageBox(HWND_DESKTOP, hWnd, szMessage,	pszAppName, 0UL, MB_ICONASTERISK | MB_OK | MB_MOVEABLE);
   }

DosFreeModule(hmod);

}
#pragma	subtitle("   Client Window - Client Window Procedure")
#pragma	page( )

/* --- TestWndProc ----------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages sent to the	*/
/*     applications client window.					*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Window Handle					*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     TestWndProc = Message Handling Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY TestWndProc(HWND hWnd,	ULONG msg, MPARAM mp1, MPARAM mp2)

{
RECTL rcl;			   /* Window Rectangle			*/
HPS   hPS;			   /* Presentation Space Handle		*/

switch ( msg )
   {
		       /* Client window	creation			*/
   case	WM_CREATE :
       hptrWait	 = WinQuerySysPointer(HWND_DESKTOP, SPTR_WAIT,	FALSE);
       hptrArrow = WinQuerySysPointer(HWND_DESKTOP, SPTR_ARROW,	FALSE);
       break;
			/* Close the application			*/
   case	WM_CLOSE :
       WinPostMsg(hWnd,	WM_QUIT, 0L, 0L);
       break;
			/* Process menu	and button selections		*/
   case	WM_COMMAND :
       switch (	SHORT1FROMMP(mp1) )
	   {
	   case	IDM_DYNAMICLOAD	:
	       if ( WinDlgBox(HWND_DESKTOP, hwndTestBedFrame, (PFNWP)LoadPMCXDLLDlgProc, (HMODULE)NULL,	DLG_LOADPMCXDLL, NULL) )
		   TestDynamicLoad(hWnd, szDLL);
	       break;

	    case IDM_ABOUT :
		WinDlgBox(HWND_DESKTOP,	hwndTestBedFrame, (PFNWP)AboutDlgProc, (HMODULE)NULL, DLG_ABOUT, NULL);
		break;

	   case	IDM_EXIT :
	       WinPostMsg(hWnd,	WM_CLOSE, 0L, 0L);
	       break;

	   }
       break;
			/* Window being	destroyed, perform clean-up	*/
			/* operations					*/
   case	WM_ERASEBACKGROUND :
       WinQueryWindowRect(hWnd,	&rcl);
       WinFillRect((HPS)LONGFROMMP(mp1), &rcl, SYSCLR_WINDOW);
       break;
			/* Paint client	window				*/
   case	WM_PAINT :
       WinFillRect(hPS = WinBeginPaint(hWnd, (HPS)NULL,	&rcl), &rcl, SYSCLR_WINDOW);
       WinEndPaint(hPS);
       break;
			/* Default message processing			*/
   default :
       return(WinDefWindowProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
